/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands;

import com.sing.warpcommands.Configure;
import com.sing.warpcommands.commands.CommandBack;
import com.sing.warpcommands.commands.CommandBye;
import com.sing.warpcommands.commands.CommandHome;
import com.sing.warpcommands.commands.CommandPos;
import com.sing.warpcommands.commands.CommandSpawn;
import com.sing.warpcommands.commands.CommandTeleportPlayer;
import com.sing.warpcommands.commands.CommandWarp;
import com.sing.warpcommands.commands.utils.IMatchProvider;
import com.sing.warpcommands.commands.utils.Utils;
import com.sing.warpcommands.data.CapabilityPlayer;
import com.sing.warpcommands.jeic.JEIChIntegration;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

@Mod(modid="simple_warp_commands", name="Simple Warp Commands", version="1.12.2-0.4.2", dependencies="after:jecharacters@[1.12.0-3.6.1,);")
@Mod.EventBusSubscriber
public class WarpCommandsMod {
    private static IMatchProvider matchProvider;

    @Mod.EventHandler
    void preInit(FMLPreInitializationEvent e) {
        CapabilityManager.INSTANCE.register(CapabilityPlayer.PlayerLocations.class, (Capability.IStorage)new Capability.IStorage<CapabilityPlayer.PlayerLocations>(){

            @Nullable
            public NBTBase writeNBT(Capability<CapabilityPlayer.PlayerLocations> capability, CapabilityPlayer.PlayerLocations playerLocations, EnumFacing direction) {
                return null;
            }

            public void readNBT(Capability<CapabilityPlayer.PlayerLocations> capability, CapabilityPlayer.PlayerLocations playerLocations, EnumFacing direction, NBTBase inbt) {
            }
        }, () -> null);
        Configure.update();
    }

    public WarpCommandsMod() {
        matchProvider = Loader.isModLoaded((String)"jecharacters") ? JEIChIntegration.provider() : (match, str) -> Utils.matchesSubStr(match, str, (a, starts, b) -> a.startsWith(b));
    }

    @Mod.EventHandler
    void serverInit(FMLServerStartingEvent e) {
        if (Configure.commands.enableWarpCommand) {
            CommandWarp.init(e);
        }
        if (Configure.commands.enableHomeCommand) {
            CommandHome.init(e);
        }
        if (Configure.commands.enableBackCommand) {
            CommandBack.init(e);
        }
        if (Configure.commands.enableSpawnCommand) {
            CommandSpawn.init(e);
        }
        if (Configure.commands.enablePosCommand) {
            CommandPos.init(e);
        }
        if (Configure.commands.enableTpPlayerCommand) {
            e.registerServerCommand((ICommand)new CommandTeleportPlayer());
        }
        if (Configure.commands.enableByeCommand) {
            e.registerServerCommand((ICommand)new CommandBye());
        }
    }

    @SubscribeEvent
    static void attachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> e) {
        if (!(e.getObject() instanceof EntityPlayer)) {
            return;
        }
        CapabilityPlayer.ProvidePlayer p = new CapabilityPlayer.ProvidePlayer();
        e.addCapability(WarpCommandsMod.id("PlayerLocations"), (ICapabilityProvider)p);
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone e) {
        CapabilityPlayer.PlayerLocations original = CapabilityPlayer.get(e.getOriginal());
        CapabilityPlayer.PlayerLocations p = CapabilityPlayer.get(e.getEntityPlayer());
        if (p == null || original == null) {
            return;
        }
        p.homePosition.position = original.homePosition.position;
        p.backPosition.position = original.backPosition.position;
        p.recordedPosition.position = original.recordedPosition.position;
    }

    @SubscribeEvent
    static void onEntityDeath(LivingDeathEvent e) {
        if (!Configure.doBackRecordDeath || !(e.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntity();
        CapabilityPlayer.PlayerLocations l = CapabilityPlayer.get(player);
        if (l != null) {
            l.backPosition.relocate(player);
        }
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("simple_warp_commands", id);
    }

    public static int matchSubStr(String str, String match) {
        return matchProvider.match(str, match);
    }
}

