/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.commands;

import com.sing.warpcommands.commands.utils.AbstractCommand;
import com.sing.warpcommands.commands.utils.Utils;
import com.sing.warpcommands.data.CapabilityPlayer;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandHome {
    public static void init(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandHomeTeleport());
        e.registerServerCommand((ICommand)new CommandHomeSet());
    }

    static class CommandHomeSet
    extends AbstractCommand {
        CommandHomeSet() {
        }

        @NotNull
        public String func_71517_b() {
            return "sethome";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = CommandHomeSet.asPlayer(sender);
            CapabilityPlayer.PlayerLocations loc = this.getPlayerCapabilities(player);
            switch (args.length) {
                case 0: {
                    loc.homePosition.relocate((EntityPlayer)player);
                    this.sendSuccess(TextFormatting.DARK_GREEN, sender, new Object[0]);
                    break;
                }
                case 1: {
                    if (!args[0].equals("reset")) {
                        this.badUsage();
                    }
                    loc.homePosition.clear();
                    CommandHomeSet.sendSuccess("sethome.reset", TextFormatting.DARK_AQUA, sender, new Object[0]);
                    break;
                }
                default: {
                    this.badUsage();
                }
            }
        }

        @Override
        @NotNull
        public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args, @Nullable BlockPos targetPos) {
            return CommandHomeSet.optionsStartsWith(args[0], "reset");
        }

        @Override
        @NotNull
        public List<String> func_71514_a() {
            return Collections.singletonList("home!");
        }
    }

    static class CommandHomeTeleport
    extends AbstractCommand {
        CommandHomeTeleport() {
        }

        @NotNull
        public String func_71517_b() {
            return "home";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            EntityPlayerMP player = this.playerOperand(sender, args);
            CapabilityPlayer.PlayerLocations loc = this.getPlayerCapabilities(player);
            if (loc.homePosition.exist()) {
                loc.homePosition.teleport(player);
            } else {
                Utils.getPlayerBedLocation((EntityPlayer)player, server).orElseThrow(() -> new CommandException(I18n.func_135052_a((String)"home.tip", (Object[])new Object[0]), new Object[0])).teleport(player);
            }
            this.sendSuccess(TextFormatting.LIGHT_PURPLE, sender, new Object[0]);
        }
    }
}

