/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.commands;

import com.sing.warpcommands.commands.utils.AbstractCommand;
import com.sing.warpcommands.commands.utils.Utils;
import com.sing.warpcommands.utils.EntityPos;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSpawn {
    public static void init(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandSpawnTeleport());
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    static class CommandSpawnTeleport
    extends AbstractCommand {
        CommandSpawnTeleport() {
        }

        public String func_71517_b() {
            return "spawn";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = CommandSpawnTeleport.asPlayer(sender);
            WorldServer world = server.func_71218_a(player.getSpawnDimension());
            if (args.length == 1 && !args[0].equals("world") || args.length > 1) {
                this.badUsage();
            }
            Optional<EntityPos> targetPos = args.length == 0 ? Utils.getPlayerBedLocation((EntityPlayer)player, server) : Optional.empty();
            targetPos.orElseGet(() -> new EntityPos(world.field_73011_w.getRandomizedSpawnPoint(), world.field_73011_w.getDimension())).teleport(player);
            this.sendSuccess(TextFormatting.AQUA, (ICommandSender)player, new Object[0]);
        }

        @Override
        @NotNull
        public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args, @Nullable BlockPos targetPos) {
            return args.length == 1 ? CommandSpawnTeleport.optionsStartsWith(args[0], "world") : Collections.emptyList();
        }
    }
}

