/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.commands;

import com.sing.warpcommands.Configure;
import com.sing.warpcommands.WarpCommandsMod;
import com.sing.warpcommands.commands.utils.AbstractCommand;
import com.sing.warpcommands.commands.utils.Utils;
import com.sing.warpcommands.data.WorldDataWaypoints;
import com.sing.warpcommands.utils.EntityPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandWarp {
    private static ITextComponent waypointName(String s) {
        return new TextComponentString(s).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    }

    private static List<String> completeWaypoint(World world, String name) {
        class StoreStruct {
            public final int startIndex;
            public final String name;

            public StoreStruct(int startIndex, String name) {
                this.startIndex = startIndex;
                this.name = name;
            }
        }
        ArrayList<StoreStruct> suggestions = new ArrayList<StoreStruct>();
        WorldDataWaypoints.IWaypointList waypoints = WorldDataWaypoints.get(world);
        int target = world.field_73011_w.getDimension();
        for (Map.Entry<String, EntityPos> waypoint : waypoints.entries()) {
            int matchIndex = WarpCommandsMod.matchSubStr(waypoint.getKey(), name);
            if (!Configure.couldTeleportTo(target, waypoint.getValue().dim) || matchIndex == -1) continue;
            suggestions.add(new StoreStruct(matchIndex, waypoint.getKey()));
        }
        return suggestions.stream().sorted(Comparator.comparingInt(i -> i.startIndex)).map(i -> i.name).collect(Collectors.toList());
    }

    private static String dotString(int count) {
        char[] res = new char[count];
        Arrays.fill(res, '\u00b7');
        return new String(res);
    }

    @NotNull
    private static ITextComponent getWarpInfoMessage(String name, EntityPos data, boolean ableToTeleport) {
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int nameWidth = renderer.func_78256_a(name);
        int spaceWidth = renderer.func_78256_a("\u00b7");
        String dataString = data.toString();
        int dataWidth = renderer.func_78256_a(dataString);
        int paddedCount = Math.max((Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146228_f() - nameWidth - dataWidth - 5) / spaceWidth, 0);
        ITextComponent nameComponent = CommandWarp.waypointName(name);
        nameComponent.func_150256_b().func_150217_b(Boolean.valueOf(!ableToTeleport));
        return nameComponent.func_150257_a(new TextComponentString(CommandWarp.dotString(paddedCount)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY))).func_150257_a(new TextComponentString(dataString).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
    }

    public static void init(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandWarpTeleport());
        e.registerServerCommand((ICommand)new CommandWarpDel());
        e.registerServerCommand((ICommand)new CommandWarpSet());
        e.registerServerCommand((ICommand)new CommandWarpOperation());
    }

    static class CommandWarpOperation
    extends AbstractCommand {
        CommandWarpOperation() {
        }

        @NonNls
        @NotNull
        public String func_71517_b() {
            return "warps";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            EntityPlayerMP player = CommandWarpOperation.asPlayer(sender);
            WorldDataWaypoints.IWaypointList data = WorldDataWaypoints.get(player.field_70170_p);
            final int dim = player.field_71093_bK;
            if (args.length == 0 || args[0].equals("list")) {
                if (data.size() == 0) {
                    throw new CommandException("warps.no_warp", new Object[0]);
                }
                if (args.length > 1) {
                    this.badUsage();
                }
                Collection<Map.Entry<String, EntityPos>> entries = data.entries();
                class ListElem
                implements Comparable<ListElem> {
                    public final EntityPos pos;
                    public final String name;
                    public final double distance;

                    public ListElem(EntityPos pos, String name, Entity entity) {
                        this.pos = pos;
                        this.name = name;
                        this.distance = pos.distanceSquared(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    }

                    @Override
                    public int compareTo(@NotNull ListElem target) {
                        return Comparator.comparingDouble(elem -> elem.distance).thenComparing(elem -> elem.pos.dim != dim).thenComparing(elem -> !Configure.couldTeleportTo(dim, elem.pos.dim)).thenComparing(elem -> elem.pos.dim).thenComparing(elem -> elem.name).compare(this, target);
                    }
                }
                TreeSet<ListElem> elems = new TreeSet<ListElem>();
                for (Map.Entry<String, EntityPos> entry : entries) {
                    EntityPos pos = entry.getValue();
                    elems.add(new ListElem(pos, entry.getKey(), (Entity)player));
                }
                sender.func_145747_a(Utils.joinTextComponent(elems.stream().map(i -> CommandWarp.getWarpInfoMessage(i.name, i.pos, Configure.couldTeleportTo(dim, i.pos.dim))).collect(Collectors.toList()), (ITextComponent)new TextComponentString("\n")));
                return;
            }
            if (args.length < 2) {
                this.badUsage();
            }
            String name = args[1];
            switch (args[0]) {
                case "rename": {
                    this.argumentsInLength(args, 3);
                    EntityPos removed = data.remove(name);
                    if (removed == null) {
                        throw new CommandException("warp.not_found", new Object[]{name});
                    }
                    if (data.has(args[2])) {
                        throw new CommandException("setwarp.replace", new Object[]{name});
                    }
                    data.set(args[2], removed);
                    CommandWarpOperation.sendSuccess("warps.rename", TextFormatting.AQUA, sender, CommandWarp.waypointName(name), CommandWarp.waypointName(args[2]));
                    break;
                }
                case "get": {
                    EntityPos pos = data.get(name);
                    if (pos == null) {
                        throw new CommandException("warp.not_found", new Object[]{name});
                    }
                    this.argumentsInLength(args, 2);
                    sender.func_145747_a(CommandWarp.getWarpInfoMessage(name, pos, Configure.couldTeleportTo(dim, pos.dim)));
                    break;
                }
                case "move": {
                    this.argumentsInLength(args, 2);
                    EntityPos pos = data.get(name);
                    if (pos == null) {
                        throw new CommandException("warp.not_found", new Object[]{name});
                    }
                    if (pos.dim != player.field_71093_bK) {
                        throw new CommandException("warps.invalid_move", new Object[0]);
                    }
                    data.relocate(name, new EntityPos((Entity)player));
                    CommandWarpOperation.sendSuccess("warps.move", TextFormatting.AQUA, sender, CommandWarp.waypointName(name));
                    break;
                }
                default: {
                    this.badUsage();
                }
            }
        }

        @Override
        @NotNull
        public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args, @Nullable BlockPos targetPos) {
            switch (args.length) {
                case 1: {
                    return CommandWarpOperation.optionsStartsWith(args[0], "rename", "get", "move", "list");
                }
                case 2: {
                    if (args[0].equals("list")) break;
                    return CommandWarp.completeWaypoint(sender.func_130014_f_(), args[1]);
                }
            }
            return Collections.emptyList();
        }
    }

    static class CommandWarpDel
    extends AbstractCommand {
        CommandWarpDel() {
        }

        @NotNull
        public String func_71517_b() {
            return "delwarp";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            String name = this.firstArgOnly(args);
            WorldDataWaypoints.IWaypointList data = WorldDataWaypoints.get(sender.func_130014_f_());
            if (data.remove(name) == null) {
                throw new CommandException("warp.not_found", new Object[]{name});
            }
            this.sendSuccess(TextFormatting.DARK_AQUA, sender, CommandWarp.waypointName(name));
        }

        @Override
        @NotNull
        public List<String> func_71514_a() {
            return Collections.singletonList("warp-");
        }

        @Override
        @NotNull
        public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args, @Nullable BlockPos targetPos) {
            return CommandWarp.completeWaypoint(sender.func_130014_f_(), args[0]);
        }
    }

    static class CommandWarpSet
    extends AbstractCommand {
        CommandWarpSet() {
        }

        @NotNull
        public String func_71517_b() {
            return "setwarp";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            String name = this.firstArgOnly(args);
            Entity entity = CommandWarpSet.asEntity(sender);
            WorldDataWaypoints.IWaypointList data = WorldDataWaypoints.get(entity.field_70170_p);
            if (data.has(name)) {
                throw new CommandException(I18n.func_135052_a((String)"setwarp.replace", (Object[])new Object[]{name}), new Object[0]);
            }
            data.set(name, new EntityPos(entity));
            this.sendSuccess(TextFormatting.GREEN, sender, CommandWarp.waypointName(name));
        }

        @Override
        @NotNull
        public List<String> func_71514_a() {
            return Collections.singletonList("warp+");
        }
    }

    static class CommandWarpTeleport
    extends AbstractCommand {
        CommandWarpTeleport() {
        }

        @NotNull
        public String func_71517_b() {
            return "warp";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            String name = this.firstArgOnly(args);
            EntityPlayerMP player = CommandWarpTeleport.asPlayer(sender);
            EntityPos p = WorldDataWaypoints.get(player.field_70170_p).get(name);
            if (p == null) {
                throw new CommandException("warp.not_found", new Object[]{name});
            }
            p.teleport(player);
            this.sendSuccess(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE).func_150217_b(Boolean.valueOf(true)), sender, CommandWarp.waypointName(name));
        }

        @Override
        @NotNull
        public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args, @Nullable BlockPos targetPos) {
            return CommandWarp.completeWaypoint(sender.func_130014_f_(), args[0]);
        }
    }
}

