/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.commands.utils;

import com.sing.warpcommands.Configure;
import com.sing.warpcommands.data.CapabilityPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public abstract class AbstractCommand
implements ICommand {
    @Contract(value="->fail")
    public final void badUsage() throws WrongUsageException {
        throw new WrongUsageException(this.func_71517_b() + ".usage", new Object[0]);
    }

    @NotNull
    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + ".usage";
    }

    public final boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !Configure.requireOp || sender instanceof EntityPlayerMP && server.func_184103_al().func_152596_g(((EntityPlayerMP)sender).func_146103_bH());
    }

    @NotNull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public final int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    @NotNull
    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public static EntityPlayerMP asPlayer(ICommandSender sender) throws PlayerNotFoundException {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new PlayerNotFoundException("commands.generic.player.unspecified");
        }
        return (EntityPlayerMP)sender;
    }

    public static Entity asEntity(ICommandSender sender) throws EntityNotFoundException {
        if (!(sender instanceof Entity)) {
            throw new EntityNotFoundException("");
        }
        return (Entity)sender;
    }

    public static List<String> optionsStartsWith(String arg, String ... options) {
        return AbstractCommand.optionsStartsWith(arg, Arrays.asList(options));
    }

    public static List<String> optionsStartsWith(String arg, Collection<String> options) {
        ArrayList<String> res = options.stream().filter(i -> i.regionMatches(true, 0, arg, 0, arg.length())).collect(Collectors.toList());
        return res.isEmpty() ? new ArrayList<String>(options) : res;
    }

    public final void argumentsInLength(String[] args, int len) throws WrongUsageException {
        if (args.length != len) {
            this.badUsage();
        }
    }

    public final String firstArgOnly(String[] args) throws WrongUsageException {
        if (args.length != 1) {
            this.badUsage();
        }
        return args[0];
    }

    public final void noArguments(String[] args) throws WrongUsageException {
        if (args.length != 0) {
            this.badUsage();
        }
    }

    public final EntityPlayerMP playerOperand(ICommandSender sender, String[] args) throws WrongUsageException, PlayerNotFoundException {
        this.noArguments(args);
        return AbstractCommand.asPlayer(sender);
    }

    public void sendSuccess(TextFormatting style, ICommandSender sender, Object ... args) {
        AbstractCommand.sendSuccess(this.func_71517_b(), style, sender, args);
    }

    public void sendSuccess(Style style, ICommandSender sender, Object ... args) {
        AbstractCommand.sendSuccess(this.func_71517_b(), style, sender, args);
    }

    public static void sendSuccess(String key, TextFormatting style, ICommandSender sender, Object ... args) {
        sender.func_145747_a(new TextComponentTranslation(key + ".success", args).func_150255_a(new Style().func_150238_a(style)));
    }

    public static void sendSuccess(String key, Style style, ICommandSender sender, Object ... args) {
        sender.func_145747_a(new TextComponentTranslation(key + ".success", args).func_150255_a(style));
    }

    public final CapabilityPlayer.PlayerLocations getPlayerCapabilities(EntityPlayerMP player) throws CommandException {
        return AbstractCommand.nonNull(CapabilityPlayer.get((EntityPlayer)player));
    }

    public final void sendSuccessSet(ICommandSender sender) {
        sender.func_145747_a(new TextComponentTranslation("locations.beset", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
    }

    @Contract(value="null->fail")
    public static <T> T nonNull(@Nullable T obj) throws CommandException {
        if (obj == null) {
            throw new CommandException("Null", new Object[0]);
        }
        return obj;
    }
}

