/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.commands.utils;

import com.sing.warpcommands.utils.EntityPos;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class Utils {
    public static Optional<EntityPos> getPlayerBedLocation(EntityPlayer player, MinecraftServer server) {
        int dim = player.getSpawnDimension();
        return Optional.ofNullable(player.getBedLocation(dim)).map(pos -> EntityPlayer.func_180467_a((World)server.func_71218_a(0), (BlockPos)pos, (boolean)player.isSpawnForced(dim))).map(x -> new EntityPos(x.func_177963_a(0.5, 0.1, 0.5), dim));
    }

    public static int findFirstSymbol(String str, int startsWith) {
        for (int i = startsWith; i < str.length(); ++i) {
            int type = Character.getType(str.charAt(i));
            if (type < 20 || type > 30) continue;
            return i;
        }
        return -1;
    }

    public static int matchesSubStr(String match, String str, IStringStartsWithCond cond) {
        str = str.toLowerCase();
        match = match.toLowerCase();
        int currentIndex = 0;
        while (!cond.startsAt(match, currentIndex, str)) {
            if ((currentIndex = Utils.findFirstSymbol(match, currentIndex)) == -1) {
                return -1;
            }
            ++currentIndex;
        }
        return currentIndex;
    }

    public static ITextComponent joinTextComponent(Collection<? extends ITextComponent> collection, ITextComponent splitter) {
        TextComponentString result = new TextComponentString("");
        boolean first = true;
        for (ITextComponent iTextComponent : collection) {
            if (!first) {
                result.func_150257_a(splitter);
            }
            first = false;
            result.func_150257_a(iTextComponent);
        }
        return result;
    }

    @FunctionalInterface
    public static interface IStringStartsWithCond {
        public boolean startsAt(String var1, int var2, String var3);
    }
}

