/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.data;

import com.sing.warpcommands.utils.EntityPos;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityPlayer {
    @CapabilityInject(value=PlayerLocations.class)
    public static Capability<PlayerLocations> cap;

    @Nullable
    public static PlayerLocations get(EntityPlayer player) {
        return (PlayerLocations)player.getCapability(cap, null);
    }

    public static class ProvidePlayer
    implements ICapabilitySerializable<NBTTagCompound>,
    ICapabilityProvider {
        private PlayerLocations locations = null;

        private PlayerLocations get() {
            if (this.locations == null) {
                this.locations = new PlayerLocations();
            }
            return this.locations;
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @javax.annotation.Nullable EnumFacing facing) {
            return capability == cap;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == cap ? this.get() : null);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("PlayerLocations", (NBTBase)this.get().serializeNBT());
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.get().deserializeNBT(nbt.func_74775_l("PlayerLocations"));
        }
    }

    public static class PlayerLocations {
        public final Position homePosition = new Position();
        public final Position backPosition = new Position();
        public final Position recordedPosition = new Position();

        @NotNull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            this.homePosition.serializeAs("home", compound);
            this.recordedPosition.serializeAs("recorded", compound);
            this.backPosition.serializeAs("back", compound);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("home")) {
                this.homePosition.readFromNBT(nbt.func_74775_l("home"));
            }
            if (nbt.func_74764_b("back")) {
                this.backPosition.readFromNBT(nbt.func_74775_l("back"));
            }
            if (nbt.func_74764_b("recorded")) {
                this.recordedPosition.readFromNBT(nbt.func_74775_l("recorded"));
            }
        }

        public static class Position {
            @Nullable
            public EntityPos position = null;

            public void teleport(EntityPlayerMP player) throws CommandException {
                if (this.position == null) {
                    throw new CommandException(I18n.func_135052_a((String)"locations.notfound", (Object[])new Object[0]), new Object[0]);
                }
                this.position.teleport(player);
            }

            void readFromNBT(NBTTagCompound tag) {
                this.position = EntityPos.fromNBT(tag);
            }

            void serializeAs(String name, NBTTagCompound target) {
                if (this.position == null) {
                    return;
                }
                target.func_74782_a(name, (NBTBase)this.position.serializeNBT());
            }

            public boolean exist() {
                return this.position != null;
            }

            public void relocate(@NotNull EntityPlayer e) {
                if (this.position == null) {
                    this.position = new EntityPos((Entity)e);
                } else {
                    this.position.relocate(new EntityPos((Entity)e));
                }
            }

            public void clear() {
                this.position = null;
            }

            public String toString() {
                return this.position == null ? "null" : this.position.toString();
            }
        }
    }
}

