/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.data;

import com.google.common.collect.Maps;
import com.sing.warpcommands.Configure;
import com.sing.warpcommands.utils.EntityPos;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class WorldDataWaypoints
extends WorldSavedData {
    private IWaypointsStorage storage;

    public WorldDataWaypoints(String name) {
        super(name);
        this.updateConfigure();
    }

    public static IWaypointList get(World world) {
        WorldDataWaypoints data = (WorldDataWaypoints)world.func_72943_a(WorldDataWaypoints.class, "WayPoints");
        if (data == null) {
            data = new WorldDataWaypoints("WayPoints");
            world.func_72823_a("WayPoints", (WorldSavedData)data);
        }
        return data.storage.get(world);
    }

    public void updateConfigure() {
        this.storage = Configure.warpsDimensionLocked ? new IndependentWorldWayPoint() : new SharedWorldWayPointStorage();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.storage.deserializeNBT((NBTBase)nbt.func_150295_c("WayPoints", 10));
    }

    @NotNull
    public NBTTagCompound func_189551_b(@NotNull NBTTagCompound nbt) {
        nbt.func_74782_a("WayPoints", this.storage.serializeNBT());
        return nbt;
    }

    private static NBTTagCompound storeEntityPos(String name, EntityPos pos) {
        NBTTagCompound nbt = pos.serializeNBT();
        nbt.func_74778_a("name", name);
        return nbt;
    }

    private class IndependentWorldWayPoint
    implements IWaypointsStorage {
        private final Int2ObjectMap<Object2ObjectMap<String, IndependentEntityPos>> waypointsMap = new Int2ObjectOpenHashMap();

        private IndependentWorldWayPoint() {
        }

        private IndependentWaypoints getForDim(int dim) {
            return new IndependentWaypoints(dim, (Object2ObjectMap)this.waypointsMap.computeIfAbsent((Object)dim, key -> new Object2ObjectOpenHashMap()));
        }

        @Override
        public IndependentWaypoints get(World world) {
            return this.getForDim(world.field_73011_w.getDimension());
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            for (Int2ObjectMap.Entry entries : this.waypointsMap.int2ObjectEntrySet()) {
                int dim = entries.getIntKey();
                for (Map.Entry entry : ((Object2ObjectMap)entries.getValue()).entrySet()) {
                    list.func_74742_a((NBTBase)WorldDataWaypoints.storeEntityPos((String)entry.getKey(), ((IndependentEntityPos)entry.getValue()).get(dim)));
                }
            }
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.waypointsMap.clear();
            for (NBTBase tag : nbt) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                IndependentWaypoints map = this.getForDim(compound.func_74762_e("dim"));
                EntityPos pos = EntityPos.fromNBT(compound);
                map.waypoints.put((Object)compound.func_74779_i("name"), (Object)new IndependentEntityPos(pos));
            }
        }
    }

    private class IndependentWaypoints
    implements IWaypointList {
        private final int dim;
        private final Object2ObjectMap<String, IndependentEntityPos> waypoints;

        private IndependentWaypoints(int dim, Object2ObjectMap<String, IndependentEntityPos> waypoints) {
            this.dim = dim;
            this.waypoints = waypoints;
        }

        @Override
        @Nullable
        public EntityPos get(String name) {
            IndependentEntityPos pos = (IndependentEntityPos)this.waypoints.get((Object)name);
            if (pos == null) {
                return null;
            }
            return pos.get(this.dim);
        }

        @Override
        public void set(String name, EntityPos pos) {
            this.waypoints.put((Object)name, (Object)new IndependentEntityPos(pos));
            WorldDataWaypoints.this.func_76185_a();
        }

        @Override
        public void relocate(String name, EntityPos target) {
            IndependentEntityPos pos = (IndependentEntityPos)this.waypoints.get((Object)name);
            if (pos == null) {
                throw new NoSuchElementException();
            }
            WorldDataWaypoints.this.func_76185_a();
            pos.x = target.x;
            pos.y = target.y;
            pos.z = target.z;
            pos.yaw = target.yaw;
            pos.pitch = target.pitch;
        }

        @Override
        public boolean has(String name) {
            return this.waypoints.containsKey((Object)name);
        }

        @Override
        @Nullable
        public EntityPos remove(String name) {
            IndependentEntityPos pos = (IndependentEntityPos)this.waypoints.remove((Object)name);
            if (pos != null) {
                WorldDataWaypoints.this.func_76185_a();
                return pos.get(this.dim);
            }
            return null;
        }

        @Override
        public Collection<Map.Entry<String, EntityPos>> entries() {
            Stream<Map.Entry> stream = this.waypoints.entrySet().stream().map(x -> Maps.immutableEntry(x.getKey(), (Object)((IndependentEntityPos)x.getValue()).get(this.dim)));
            return stream.collect(Collectors.toList());
        }

        @Override
        public int size() {
            return this.waypoints.size();
        }
    }

    private static class IndependentEntityPos {
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;

        public EntityPos get(int dim) {
            return new EntityPos(this.x, this.y, this.z, this.yaw, this.pitch, dim);
        }

        public IndependentEntityPos(EntityPos pos) {
            this.x = pos.x;
            this.y = pos.y;
            this.z = pos.z;
            this.yaw = pos.yaw;
            this.pitch = pos.pitch;
        }
    }

    private class SharedWorldWayPointStorage
    implements IWaypointsStorage {
        SharedWaypointList waypointsMap;

        private SharedWorldWayPointStorage() {
            this.waypointsMap = new SharedWaypointList();
        }

        @Override
        public SharedWaypointList get(World _world) {
            return this.waypointsMap;
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, EntityPos> entry : this.waypointsMap.entries()) {
                list.func_74742_a((NBTBase)WorldDataWaypoints.storeEntityPos(entry.getKey(), entry.getValue()));
            }
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.waypointsMap.waypoints.clear();
            for (NBTBase nbtBase : nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbtBase;
                EntityPos pos = EntityPos.fromNBT(compound);
                this.waypointsMap.waypoints.put(compound.func_74779_i("name"), pos);
            }
        }
    }

    public class SharedWaypointList
    implements IWaypointList {
        private final HashMap<String, EntityPos> waypoints = new HashMap();

        @Override
        @Nullable
        public EntityPos get(String name) {
            return this.waypoints.get(name);
        }

        @Override
        public void set(String name, EntityPos pos) {
            this.waypoints.put(name, pos);
            WorldDataWaypoints.this.func_76185_a();
        }

        @Override
        public void relocate(String name, EntityPos target) {
            EntityPos pos = this.waypoints.get(name);
            if (pos == null) {
                throw new NoSuchElementException();
            }
            WorldDataWaypoints.this.func_76185_a();
            pos.relocate(target);
        }

        @Override
        public boolean has(String name) {
            return this.waypoints.containsKey(name);
        }

        @Override
        @Nullable
        public EntityPos remove(String name) {
            EntityPos removed = this.waypoints.remove(name);
            if (removed != null) {
                WorldDataWaypoints.this.func_76185_a();
            }
            return removed;
        }

        @Override
        public Collection<Map.Entry<String, EntityPos>> entries() {
            return this.waypoints.entrySet();
        }

        @Override
        public int size() {
            return this.waypoints.size();
        }
    }

    public static interface IWaypointList {
        @Nullable
        public EntityPos get(String var1);

        public void set(String var1, EntityPos var2);

        public void relocate(String var1, EntityPos var2);

        public boolean has(String var1);

        public int size();

        @Nullable
        public EntityPos remove(String var1);

        public Collection<Map.Entry<String, EntityPos>> entries();
    }

    public static interface IWaypointsStorage
    extends INBTSerializable<NBTTagList> {
        @Nullable
        public IWaypointList get(World var1);
    }
}

