/*
 * Decompiled with CFR 0.152.
 */
package com.sing.warpcommands.utils;

import com.sing.warpcommands.Configure;
import com.sing.warpcommands.data.CapabilityPlayer;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EntityPos {
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    public int dim;

    public void relocate(EntityPos pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.yaw = pos.yaw;
        this.pitch = pos.pitch;
        this.dim = pos.dim;
    }

    public EntityPos(double x, double y, double z, float yaw, float pitch, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.dim = dim;
    }

    private EntityPos(NBTTagCompound tag) {
        this(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"), tag.func_74760_g("yaw"), tag.func_74760_g("pitch"), tag.func_74762_e("dim"));
    }

    public EntityPos(@NotNull BlockPos pos, int dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f, dim);
    }

    public EntityPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A, entity.field_71093_bK);
    }

    public static void teleport(@NotNull EntityPlayerMP target, EntityPlayerMP e) throws CommandException {
        new EntityPos((Entity)target).teleport(e);
    }

    public void teleport(EntityPlayerMP e) throws CommandException {
        if (!DimensionManager.isDimensionRegistered((int)this.dim)) {
            throw new CommandException("teleport.no_dim", new Object[0]);
        }
        CapabilityPlayer.PlayerLocations cap = CapabilityPlayer.get((EntityPlayer)e);
        if (cap != null) {
            cap.backPosition.position = new EntityPos((Entity)e);
        }
        e.func_184210_p();
        if (e.field_71093_bK == this.dim) {
            e.field_71135_a.func_147364_a(this.x, this.y, this.z, this.yaw, this.pitch);
        } else {
            if (!Configure.couldTeleportTo(e.field_71093_bK, this.dim)) {
                throw new CommandException(I18n.func_135052_a((String)"teleport.no_dimension_cross", (Object[])new Object[]{DimensionManager.getProviderType((int)e.field_71093_bK).func_186065_b(), DimensionManager.getProviderType((int)this.dim).func_186065_b()}), new Object[0]);
            }
            e.field_71133_b.func_184103_al().transferPlayerToDimension(e, this.dim, (world, entity, __) -> entity.func_70012_b(this.x, this.y, this.z, this.yaw, this.pitch));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("x", (NBTBase)new NBTTagDouble(this.x));
        nbt.func_74782_a("y", (NBTBase)new NBTTagDouble(this.y));
        nbt.func_74782_a("z", (NBTBase)new NBTTagDouble(this.z));
        nbt.func_74782_a("yaw", (NBTBase)new NBTTagFloat(this.yaw));
        nbt.func_74782_a("pitch", (NBTBase)new NBTTagFloat(this.pitch));
        nbt.func_74782_a("dim", (NBTBase)new NBTTagInt(this.dim));
        return nbt;
    }

    @Contract(value="null->null;!null->!null", pure=true)
    public static EntityPos fromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        return new EntityPos(nbt);
    }

    public double distanceSquared(double x, double y, double z) {
        return (x - this.x) * (x - this.x) + (y - this.y) * (y - this.y) + (z - this.z) * (z - this.z);
    }

    public String toString() {
        String dimName = DimensionManager.getProviderType((int)this.dim).func_186065_b();
        return Configure.showWaypointCoords ? String.format("[%.1f,%.1f,%.1f], %s", this.x, this.y, this.z, dimName) : String.format("in %s", dimName);
    }
}

