/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.variables;

import com.zeitheron.hammercore.event.PlayerLoadReadyEvent;
import com.zeitheron.hammercore.internal.variables.IVariable;
import com.zeitheron.hammercore.net.internal.PacketUpdateDirtyVariables;
import com.zeitheron.hammercore.net.transport.NetTransport;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class VariableManager {
    static final List<IVariable<?>> VARIABLES = new ArrayList();
    static final Map<ResourceLocation, IVariable<?>> DIRTY_VARS = new HashMap();

    private VariableManager() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> IVariable<T> getVariable(ResourceLocation id) {
        for (int i = 0; i < VARIABLES.size(); ++i) {
            if (!VARIABLES.get(i).getId().equals((Object)id)) continue;
            return (IVariable)Cast.cast(VARIABLES.get(i));
        }
        return null;
    }

    public static void registerVariable(IVariable<?> var) {
        if (VARIABLES.contains(var) || VariableManager.getVariable(var.getId()) != null) {
            return;
        }
        VARIABLES.add(var);
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent evt) {
        VariableManager.updateManager();
    }

    static void updateManager() {
        DIRTY_VARS.clear();
        for (int i = 0; i < VARIABLES.size(); ++i) {
            IVariable<?> var = VARIABLES.get(i);
            if (!var.hasChanged()) continue;
            DIRTY_VARS.put(var.getId(), var);
            var.setNotChanged();
        }
        if (!DIRTY_VARS.isEmpty()) {
            NetTransport.wrap(new PacketUpdateDirtyVariables(DIRTY_VARS)).sendToAll();
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerLoadReadyEvent evt) {
        VariableManager.sendVarsTo(evt.playerMP);
    }

    public static void sendVarsTo(EntityPlayerMP mp) {
        DIRTY_VARS.clear();
        for (int i = 0; i < VARIABLES.size(); ++i) {
            IVariable<?> var = VARIABLES.get(i);
            DIRTY_VARS.put(var.getId(), var);
            var.setNotChanged();
        }
        if (!DIRTY_VARS.isEmpty()) {
            NetTransport.wrap(new PacketUpdateDirtyVariables(DIRTY_VARS)).sendTo(mp);
        }
    }
}

