/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class PriorityList<T>
extends AbstractList<T> {
    private List<T> sorted = new ArrayList<T>();
    private ToIntFunction<T> prio;

    public void setPriority(Function<T, Integer> i) {
        this.prio = i::apply;
    }

    public void setPriority(ToIntFunction<T> i) {
        this.prio = i;
    }

    @Override
    public boolean add(T elem) {
        int p = this.prio.applyAsInt(elem);
        if (this.sorted.isEmpty()) {
            return this.sorted.add(elem);
        }
        for (int i = 0; i < this.sorted.size(); ++i) {
            int cp = this.prio.applyAsInt(this.sorted.get(i));
            if (p >= cp) continue;
            this.sorted.add(i, elem);
            return true;
        }
        return this.sorted.add(elem);
    }

    public PriorityList<T> invert() {
        PriorityList<T> pl = new PriorityList<T>();
        pl.prio = this.prio;
        for (int i = this.sorted.size() - 1; i >= 0; --i) {
            pl.sorted.add(this.sorted.get(i));
        }
        return pl;
    }

    public static <T> PriorityList<T> sort(List<T> src, Function<T, Integer> priority) {
        PriorityList<T> pl = new PriorityList<T>();
        pl.setPriority(priority);
        for (T i : src) {
            pl.add(i);
        }
        return pl;
    }

    @Override
    public T get(int index) {
        return this.sorted.get(index);
    }

    @Override
    public int size() {
        return this.sorted.size();
    }

    public static class PriorityHolder<T> {
        public final T val;
        public final int prior;

        public PriorityHolder(T value, int priority) {
            this.val = value;
            this.prior = priority;
        }

        public static <K> Function<PriorityHolder<K>, Integer> sorter() {
            return holder -> holder.prior;
        }
    }
}

