/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;

public class PositionedSearching<T> {
    public List<T> located = new ArrayList<T>();
    public Class<T> tileType;
    public Function<BlockPos, T> getter;
    public Predicate<T> valid;
    public BlockPos center;
    public int radiusX;
    public int radiusY;
    public int radiusZ;
    List<BlockPos> check = new ArrayList<BlockPos>();
    BlockPos current;

    public PositionedSearching(Function<BlockPos, T> getter, Predicate<T> valid, Class<T> tileType) {
        this.getter = getter;
        this.valid = valid;
        this.tileType = tileType;
    }

    public void setRadius(int radius) {
        this.setRadius(radius, radius, radius);
    }

    public void setRadius(int radiusX, int radiusY, int radiusZ) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.bakeCheckList();
    }

    public void bakeCheckList() {
        this.check.clear();
        if (this.center != null && this.radiusX > 0 && this.radiusY > 0 && this.radiusZ > 0) {
            for (int x = -this.radiusX; x <= this.radiusX; ++x) {
                for (int y = -this.radiusY; y <= this.radiusY; ++y) {
                    for (int z = -this.radiusZ; z <= this.radiusZ; ++z) {
                        this.check.add(this.center.func_177982_a(x, y, z));
                    }
                }
            }
        }
    }

    public void setCenter(BlockPos center) {
        this.center = center;
        this.bakeCheckList();
    }

    public void update(int searches) {
        this.located.removeIf(this.valid.negate());
        for (int i = 0; i < searches; ++i) {
            this.continueSearch();
        }
    }

    public void continueSearch() {
        T i;
        if (this.check.isEmpty()) {
            return;
        }
        int fo = this.check.indexOf(this.current);
        if (fo == -1) {
            this.current = this.check.get(0);
        }
        if ((i = this.getter.apply(this.current)) != null && !this.located.contains(i)) {
            this.located.add(i);
        }
        this.current = this.check.get((fo + 1) % this.check.size());
    }
}

