/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.structure.io;

import com.zeitheron.hammercore.utils.WorldLocation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class StructureElement {
    public BlockPos relativePos = BlockPos.field_177992_a;
    public NBTTagCompound nbt;
    public String block;
    public int meta;

    public StructureElement(String block, int meta, String nbt, BlockPos rel) {
        this.block = block;
        this.meta = meta;
        this.relativePos = rel;
        if (nbt != null && !nbt.isEmpty()) {
            try {
                this.nbt = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public IBlockState getState() {
        return ((Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(this.block))).func_176203_a(this.meta);
    }

    public NBTTagCompound getTileTag() {
        return this.nbt != null ? this.nbt.func_74737_b() : new NBTTagCompound();
    }

    public void place(WorldLocation loc) {
        loc.setState(this.getState());
        TileEntity tile = loc.getTile();
        tile.func_145839_a(tile.func_189515_b(this.getTileTag()));
    }

    public static StructureElement capture(WorldLocation loc, WorldLocation center) {
        String nbt = "";
        TileEntity tile = loc.getTile();
        if (tile != null) {
            nbt = tile.func_189515_b(new NBTTagCompound()).toString();
        }
        return new StructureElement(loc.getBlock().getRegistryName().toString(), loc.getMeta(), nbt, loc.getPos().func_177973_b((Vec3i)center.getPos()));
    }
}

