/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.biome.MapBiomes;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.common.config.CommonConfig;
import xaero.map.common.config.CommonConfigIO;
import xaero.map.common.config.CommonConfigInit;
import xaero.map.controls.ControlsRegister;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.events.ClientEvents;
import xaero.map.events.CommonEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.file.export.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandler;
import xaero.map.message.WorldMapMessageHandlerForge;
import xaero.map.message.WorldMapMessageRegister;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.patreon.Patreon;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.pool.buffer.TextureDirectBufferPool;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderer;
import xaero.map.radar.tracker.system.PlayerTrackerSystemManager;
import xaero.map.radar.tracker.system.impl.SyncedPlayerTrackerSystem;
import xaero.map.region.OverlayManager;
import xaero.map.server.WorldMapServer;
import xaero.map.server.mods.SupportServerMods;
import xaero.map.server.player.ServerPlayerTickHandler;
import xaero.map.settings.ModSettings;

@Mod(modid="xaeroworldmap", name="Xaero's World Map", version="1.39.12", guiFactory="xaero.map.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*")
public class WorldMap {
    public static final Logger LOGGER = LogManager.getLogger();
    @Mod.Instance(value="xaeroworldmap")
    public static WorldMap instance;
    public static int MINIMAP_COMPATIBILITY_VERSION;
    private static final String versionID_minecraft = "1.12";
    private static final String versionID_mod;
    public static final String versionID;
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static boolean loaded;
    public static ClientEvents events;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static TextureUploadPool.SubsequentNormal subsequentNormalTextureUploadPool;
    public static TextureDirectBufferPool textureDirectBufferPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static MapBiomes mapBiomes;
    public static final ResourceLocation guiTextures;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    public static MapElementRenderHandler mapElementRenderHandler;
    public static ServerPlayerTickHandler serverPlayerTickHandler;
    public static PlayerTrackerSystemManager playerTrackerSystemManager;
    public static PlayerTrackerMapElementRenderer trackedPlayerRenderer;
    public static PlayerTrackerMenuRenderer trackedPlayerMenuRenderer;
    public static WorldMapMessageHandler messageHandler;
    public static CommonEvents commonEvents;
    public static CommonConfigIO commonConfigIO;
    public static CommonConfig commonConfig;
    public static final SimpleNetworkWrapper network;
    private WorldMapServer worldmapServer;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        new CommonConfigInit().init(event.getSide() == Side.SERVER, event.getModConfigurationDirectory().toPath(), "xaeroworldmap-common.txt");
        commonEvents = new CommonEvents();
        MinecraftForge.EVENT_BUS.register((Object)commonEvents);
        MinecraftForge.EVENT_BUS.register((Object)new ModCommonEvents());
        if (event.getSide() == Side.SERVER) {
            return;
        }
        trackedPlayerRenderer = PlayerTrackerMapElementRenderer.Builder.begin().build();
        trackedPlayerMenuRenderer = PlayerTrackerMenuRenderer.Builder.begin().setRenderer(trackedPlayerRenderer).build();
        String modId = this.getClass().getAnnotation(Mod.class).modid();
        worldMapClient = new WorldMapClient();
        worldMapClient.preInit(event, modId);
        if (event.getSourceFile().getName().endsWith(".jar")) {
            modJAR = event.getSourceFile();
        }
        Path gameDir = WorldMap.getGameDir();
        configFolder = event.getModConfigurationDirectory();
        optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
        Path oldSaveFolder4 = gameDir.resolve("XaeroWorldMap");
        Path xaeroFolder = gameDir.resolve("xaero");
        if (!Files.exists(xaeroFolder, new LinkOption[0])) {
            Files.createDirectories(xaeroFolder, new FileAttribute[0]);
        }
        saveFolder = xaeroFolder.resolve("world-map").toFile();
        if (oldSaveFolder4.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder4, saveFolder.toPath(), new CopyOption[0]);
        }
        Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
        File oldOptionsFile = gameDir.resolve("xaeroworldmap.txt").toFile();
        File oldSaveFolder = gameDir.resolve("mods").resolve("XaeroWorldMap").toFile();
        File oldSaveFolder2 = gameDir.resolve("config").resolve("XaeroWorldMap").toFile();
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object patreonEntry;
        messageHandler = new WorldMapMessageHandlerForge();
        new WorldMapMessageRegister().register(messageHandler);
        serverPlayerTickHandler = new ServerPlayerTickHandler();
        SupportServerMods.check();
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer = new WorldMapServer();
            this.worldmapServer.load(event);
            return;
        }
        events = new ClientEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        settings = new ModSettings();
        settings.loadSettings();
        Patreon.checkPatreon();
        Internet.checkModVersion();
        if (isOutdated && (patreonEntry = Patreon.getMods().get(fileLayoutID)) != null) {
            Patreon.setModInfo(patreonEntry, modJAR, versionID, latestVersion, latestVersionMD5, new Runnable(){

                @Override
                public void run() {
                    ModSettings.ignoreUpdate = newestUpdateID;
                    try {
                        settings.saveSettings();
                    }
                    catch (IOException e) {
                        LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            });
            Patreon.addOutdatedMod(patreonEntry);
        }
        waypointSymbolCreator = new WaypointSymbolCreator();
        controlsRegister = new ControlsRegister();
        ServerWorldCapabilities.registerCapabilities();
        bufferDeallocator = new ByteBufferDeallocator();
        tilePool = new MapTilePool();
        overlayManager = new OverlayManager();
        pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        mapLimiter = new MapLimiter();
        normalTextureUploadPool = new TextureUploadPool.Normal(256);
        compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
        branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
        branchDownloadPool = new TextureUploadPool.BranchDownload(256);
        textureDirectBufferPool = new TextureDirectBufferPool();
        subsequentNormalTextureUploadPool = new TextureUploadPool.SubsequentNormal(256);
        textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256, 256);
        glObjectDeleter = new GLObjectDeleter();
        crashHandler = new CrashHandler();
        mapBiomes = new MapBiomes();
        mapRunner = new MapRunner();
        mapRunnerThread = new Thread(mapRunner);
        mapRunnerThread.start();
    }

    public static Path getGameDir() {
        return Minecraft.func_71410_x().field_71412_D.toPath().toAbsolutePath();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer.loadLater();
            this.worldmapServer = null;
            loaded = true;
            return;
        }
        settings.findMapItem();
        settings.updateRegionCacheHashCode();
        playerTrackerSystemManager.register("map_synced", new SyncedPlayerTrackerSystem());
        SupportMods.load();
        mapElementRenderHandler = MapElementRenderHandler.Builder.begin().build();
        loaded = true;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        commonEvents.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        commonEvents.onServerStopped(event);
    }

    public static void onSessionFinalized() {
        mapLimiter.onSessionFinalized();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onSessionFinalized();
        }
    }

    static {
        MINIMAP_COMPATIBILITY_VERSION = 26;
        versionID_mod = WorldMap.class.getAnnotation(Mod.class).version();
        versionID = "1.12_" + versionID_mod;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        globalVersion = 1;
        playerTrackerSystemManager = new PlayerTrackerSystemManager();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(WorldMapMessage.MAIN_CHANNEL.toString());
        modJAR = null;
    }
}

