/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;
import xaero.map.server.player.ServerPlayerData;

public class HandshakePacket
extends WorldMapMessage<HandshakePacket> {
    private int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(3);
    }

    public void toBytes(ByteBuf u) {
        u.writeInt(this.networkVersion);
    }

    public void fromBytes(ByteBuf buffer) {
        this.networkVersion = buffer.readInt();
    }

    public static class ServerHandler
    implements ServerMessageConsumer<HandshakePacket> {
        @Override
        public void handle(MinecraftServer server, EntityPlayerMP player, HandshakePacket message) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements ClientMessageConsumer<HandshakePacket> {
        @Override
        public void handle(HandshakePacket message) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMapProcessor().setServerModNetworkVersion(message.networkVersion);
            WorldMap.messageHandler.sendToServer(new HandshakePacket());
        }
    }
}

