/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.minimap.element;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.element.render.MinimapElementRenderLocation;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.element.MapElementRenderer;
import xaero.map.element.render.ElementRenderInfo;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.mods.SupportMods;
import xaero.map.mods.minimap.element.MinimapElementReaderWrapper;
import xaero.map.mods.minimap.element.MinimapElementRenderProviderWrapper;
import xaero.map.world.MapDimension;

public final class MinimapElementRendererWrapper<E, C>
extends MapElementRenderer<E, C, MinimapElementRendererWrapper<E, C>> {
    private final int order;
    private final IXaeroMinimap modMain;
    private final MinimapElementRenderer<E, C> renderer;
    private final Supplier<Boolean> shouldRenderSupplier;
    private ElementRenderInfo compatibleRenderInfo;

    private MinimapElementRendererWrapper(IXaeroMinimap modMain, C context, MinimapElementRenderProviderWrapper<E, C> provider, MinimapElementReaderWrapper<E, C> reader, MinimapElementRenderer<E, C> renderer, Supplier<Boolean> shouldRenderSupplier, int order) {
        super(context, provider, reader);
        this.order = order;
        this.renderer = renderer;
        this.modMain = modMain;
        this.shouldRenderSupplier = shouldRenderSupplier;
    }

    @Override
    @Deprecated
    public void beforeRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        ElementRenderInfo renderInfo = this.getFakeRenderInfo(location, mc, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, fontRenderer, pre, scaledRes);
        this.preRender(renderInfo, pre);
    }

    @Override
    @Deprecated
    public void afterRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        if (this.compatibleRenderInfo == null) {
            this.compatibleRenderInfo = this.getFakeRenderInfo(location, mc, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, fontRenderer, pre, scaledRes);
        }
        this.postRender(this.compatibleRenderInfo, pre);
        this.compatibleRenderInfo = null;
    }

    private ElementRenderInfo getFakeRenderInfo(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, boolean pre, ScaledResolution scaledRes) {
        MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        double mapDimScale = mapDimension.calculateDimScale();
        return new ElementRenderInfo(ElementRenderLocation.fromIndex(location), mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, new Vec3d(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, false, 1.0f, brightness, screenSizeBasedScale, null, scaledRes, mapDimScale, mapDimension.getDimId());
    }

    @Override
    @Deprecated
    public boolean renderElement(int location, E element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        if (this.compatibleRenderInfo == null) {
            MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            double mapDimScale = mapDimension.calculateDimScale();
            this.compatibleRenderInfo = new ElementRenderInfo(ElementRenderLocation.fromIndex(location), mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, new Vec3d(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, cave, partialTicks, brightness, screenSizeBasedScale, null, scaledRes, mapDimScale, mapDimension.getDimId());
        }
        return this.renderElement(element, hovered, optionalDepth, optionalScale, partialX, partialY, this.compatibleRenderInfo);
    }

    @Override
    public void preRender(ElementRenderInfo renderInfo, boolean shadow) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.renderer.preRender(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), renderInfo.renderEntity, renderInfo.player, renderInfo.renderPos.field_72450_a, renderInfo.renderPos.field_72448_b, renderInfo.renderPos.field_72449_c, renderInfo.scaledResolution, this.modMain);
    }

    @Override
    public void postRender(ElementRenderInfo renderInfo, boolean shadow) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.renderer.postRender(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), renderInfo.renderEntity, renderInfo.player, renderInfo.renderPos.field_72450_a, renderInfo.renderPos.field_72448_b, renderInfo.renderPos.field_72449_c, renderInfo.scaledResolution, this.modMain);
    }

    @Override
    public boolean renderElement(E element, boolean hovered, double optionalDepth, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo) {
        Minecraft mc = Minecraft.func_71410_x();
        MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
        if (SupportMods.xaeroMinimap.compatibilityVersion >= 12) {
            return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), hovered, false, mc.field_71466_p, renderInfo.framebuffer, helper, mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, renderInfo.renderPos.field_72450_a, renderInfo.renderPos.field_72448_b, renderInfo.renderPos.field_72449_c, 0, optionalDepth, optionalScale, element, partialX, partialY, renderInfo.cave, renderInfo.partialTicks, renderInfo.scaledResolution);
        }
        return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), hovered, mc.field_71466_p, renderInfo.framebuffer, helper, mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, renderInfo.renderPos.field_72450_a, renderInfo.renderPos.field_72448_b, renderInfo.renderPos.field_72449_c, 0, optionalDepth, optionalScale, element, partialX, partialY, renderInfo.cave, renderInfo.partialTicks, renderInfo.scaledResolution);
    }

    @Override
    @Deprecated
    public void renderElementPre(int location, E element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
    }

    @Override
    public void renderElementShadow(E element, boolean hovered, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo) {
    }

    @Override
    public boolean shouldRender(int location, boolean shadow) {
        return !shadow && this.shouldRenderSupplier.get() != false && this.renderer.shouldRender(location);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public static final class Builder<E, C> {
        private final MinimapElementRenderer<E, C> renderer;
        private Supplier<Boolean> shouldRenderSupplier;
        private IXaeroMinimap modMain;
        private int order;

        private Builder(MinimapElementRenderer<E, C> renderer) {
            this.renderer = renderer;
        }

        private Builder<E, C> setDefault() {
            this.setModMain(null);
            this.setShouldRenderSupplier(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return true;
                }
            });
            this.setOrder(0);
            return this;
        }

        public Builder<E, C> setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder<E, C> setShouldRenderSupplier(Supplier<Boolean> shouldRenderSupplier) {
            this.shouldRenderSupplier = shouldRenderSupplier;
            return this;
        }

        public Builder<E, C> setOrder(int order) {
            this.order = order;
            return this;
        }

        public MinimapElementRendererWrapper<E, C> build() {
            if (this.modMain == null || this.shouldRenderSupplier == null) {
                throw new IllegalStateException();
            }
            MinimapElementRenderProviderWrapper providerWrapper = new MinimapElementRenderProviderWrapper(this.renderer.getProvider());
            MinimapElementReaderWrapper readerWrapper = new MinimapElementReaderWrapper(this.renderer.getElementReader());
            Object context = this.renderer.getContext();
            return new MinimapElementRendererWrapper(this.modMain, context, providerWrapper, readerWrapper, this.renderer, this.shouldRenderSupplier, this.order);
        }

        public static <E, C> Builder<E, C> begin(MinimapElementRenderer<E, C> renderer) {
            return super.setDefault();
        }
    }
}

