/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderProvider;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderContext;

public final class PlayerTrackerMenuRenderer
extends MapElementMenuRenderer<PlayerTrackerMapElement<?>, PlayerTrackerMenuRenderContext> {
    private final PlayerTrackerIconRenderer iconRenderer;
    private final PlayerTrackerMapElementRenderer renderer;
    private GuiButton showPlayersButton;

    private PlayerTrackerMenuRenderer(PlayerTrackerMapElementRenderer renderer, PlayerTrackerIconRenderer iconRenderer, PlayerTrackerMenuRenderContext context, PlayerTrackerMapElementRenderProvider<PlayerTrackerMenuRenderContext> provider) {
        super(context, provider);
        this.iconRenderer = iconRenderer;
        this.renderer = renderer;
    }

    @Override
    public void onMapInit(final GuiMap screen, Minecraft mc, final int width, final int height) {
        super.onMapInit(screen, mc, width, height);
        final CursorBox showPlayersTooltip = new CursorBox((ITextComponent)new TextComponentTranslation(WorldMap.settings.renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints", new Object[]{new TextComponentString(Misc.getKeyName(screen.getTrackedPlayerKeyBinding())).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}), true);
        this.showPlayersButton = new GuiTexturedButton(width - 173, height - 33, 20, 20, WorldMap.settings.trackedPlayers ? 197 : 213, 48, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                PlayerTrackerMenuRenderer.this.onShowPlayersButton(screen, width, height);
            }
        }, new Supplier<CursorBox>(){

            @Override
            public CursorBox get() {
                return showPlayersTooltip;
            }
        });
        screen.addGuiButton(this.showPlayersButton);
    }

    public void onShowPlayersButton(GuiMap screen, int width, int height) {
        WorldMap.settings.trackedPlayers = !WorldMap.settings.trackedPlayers;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_146280_a(this.mc, width, height);
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }

    @Override
    public void renderInMenu(PlayerTrackerMapElement<?> element, GuiScreen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        PlayerTrackerMapElement<?> playerElement = element;
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(playerElement.getPlayerId());
        if (info != null) {
            EntityPlayer clientPlayer = mc.field_71441_e.func_152378_a(playerElement.getPlayerId());
            this.iconRenderer.renderIcon(clientPlayer, this.renderer.getTrackedPlayerIconManager().getPlayerSkin(clientPlayer, info));
        }
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 1;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_players_by_name";
    }

    @Override
    protected ElementRenderer<? super PlayerTrackerMapElement<?>, ?, ?> getRenderer(PlayerTrackerMapElement<?> element) {
        return this.renderer;
    }

    public boolean canJumpTo(PlayerTrackerMapElement<?> element) {
        return !this.renderer.getReader().isHidden(element, this.renderer.getContext());
    }

    public static final class Builder {
        private PlayerTrackerMapElementRenderer renderer;

        private Builder() {
        }

        private Builder setDefault() {
            this.setRenderer(null);
            return this;
        }

        public Builder setRenderer(PlayerTrackerMapElementRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public PlayerTrackerMenuRenderer build() {
            if (this.renderer == null) {
                throw new IllegalStateException();
            }
            return new PlayerTrackerMenuRenderer(this.renderer, new PlayerTrackerIconRenderer(), new PlayerTrackerMenuRenderContext(), new PlayerTrackerMapElementRenderProvider(this.renderer.getCollector()));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

