/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import thecodex6824.coremodlib.ASMUtil;
import thecodex6824.coremodlib.MatchDetails;

public class MatchSnapshot
implements MatchDetails {
    private final InsnList matchList;
    private final InsnList originalList;
    private final AbstractInsnNode matchEnd;
    private final AbstractInsnNode originalEnd;

    private Pair<InsnList, Integer> setupMatchList(AbstractInsnNode start, AbstractInsnNode end) {
        if (start == null || end == null) {
            return null;
        }
        int distance = 0;
        AbstractInsnNode cursor = start;
        while (cursor != end) {
            cursor = cursor.getNext();
            ++distance;
        }
        return Pair.of((Object)ASMUtil.cloneNodeRangeAndDependencies(start, end), (Object)distance);
    }

    protected MatchSnapshot(AbstractInsnNode originalStart, AbstractInsnNode matchStart, AbstractInsnNode originalEnd, AbstractInsnNode matchEnd) {
        Pair<InsnList, Integer> match = this.setupMatchList(originalStart, originalEnd);
        this.originalList = match != null ? (InsnList)match.getLeft() : null;
        this.originalEnd = this.originalList != null ? this.originalList.get(((Integer)match.getRight()).intValue()) : null;
        match = this.setupMatchList(matchStart, matchEnd);
        this.matchList = match != null ? (InsnList)match.getLeft() : null;
        this.matchEnd = this.matchList != null ? this.matchList.get(((Integer)match.getRight()).intValue()) : null;
    }

    @Override
    public boolean matched() {
        return this.matchList != null && this.matchEnd != null;
    }

    @Override
    public AbstractInsnNode matchStart() {
        return this.matchList != null ? this.matchList.getFirst() : null;
    }

    public AbstractInsnNode originalStart() {
        return this.originalList != null ? this.originalList.getFirst() : null;
    }

    @Override
    public AbstractInsnNode matchEnd() {
        return this.matchEnd;
    }

    public AbstractInsnNode originalEnd() {
        return this.originalEnd;
    }
}

