/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import java.util.List;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import thecodex6824.coremodlib.MatchTransformer;
import thecodex6824.coremodlib.MutableMatchDetails;

class PrefabMatchTransformers {
    PrefabMatchTransformers() {
    }

    public static class MakeMatchRange
    implements MatchTransformer {
        @Override
        public void transformMatch(MethodNode method, MutableMatchDetails match, List<? extends MutableMatchDetails> previousMatches) {
            if (previousMatches.isEmpty()) {
                throw new IllegalStateException("Cannot make a match range out of a single match");
            }
            InsnList insns = method.instructions;
            MutableMatchDetails otherMatch = previousMatches.remove(previousMatches.size() - 1);
            if (insns.indexOf(otherMatch.matchStart()) < insns.indexOf(match.matchStart())) {
                match.setMatchStart(otherMatch.matchStart());
            }
            if (insns.indexOf(otherMatch.matchEnd()) > insns.indexOf(match.matchEnd())) {
                match.setMatchEnd(otherMatch.matchEnd());
            }
        }

        public String toString() {
            return "Combines the last 2 matches into a single match range";
        }
    }

    public static class LastNodeOnly
    implements MatchTransformer {
        @Override
        public void transformMatch(MethodNode method, MutableMatchDetails match, List<? extends MutableMatchDetails> previousMatches) {
            match.setMatchStart(match.matchEnd());
        }

        public String toString() {
            return "Trims match to only contain the last node";
        }
    }
}

