/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.common.entities.monster.EntitySpellBat;
import thecodex6824.thaumcraftfix.IProxy;
import thecodex6824.thaumcraftfix.api.ResearchApi;
import thecodex6824.thaumcraftfix.api.aura.DefaultAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IOriginalAuraInfo;
import thecodex6824.thaumcraftfix.api.aura.OriginalAuraInfo;
import thecodex6824.thaumcraftfix.api.internal.ThaumcraftFixApiBridge;
import thecodex6824.thaumcraftfix.api.research.ResearchCategoryTheorycraftFilter;
import thecodex6824.thaumcraftfix.common.config.ThaumcraftFixConfig;
import thecodex6824.thaumcraftfix.common.internal.DefaultApiImplementation;
import thecodex6824.thaumcraftfix.common.network.ThaumcraftFixNetworkHandler;
import thecodex6824.thaumcraftfix.common.research.ResearchConfigParser;
import thecodex6824.thaumcraftfix.common.research.parser.ScanParserBlock;
import thecodex6824.thaumcraftfix.common.research.parser.ScanParserEntity;
import thecodex6824.thaumcraftfix.common.research.parser.ScanParserItem;
import thecodex6824.thaumcraftfix.common.research.parser.ScanParserItemExtended;
import thecodex6824.thaumcraftfix.common.world.AuraFinalizerWorldGenerator;

@Mod(modid="thaumcraftfix", name="Thaumcraft Fix", version="1.12.2-1.1.4", useMetadata=true, certificateFingerprint="8f678591ba6f78d579e553a8aa94b4c4766cb13d")
@Mod.EventBusSubscriber
public class ThaumcraftFix {
    public static final String VERSION = "1.12.2-1.1.4";
    @Mod.Instance(value="thaumcraftfix")
    public static ThaumcraftFix instance;
    @SidedProxy(modId="thaumcraftfix", serverSide="thecodex6824.thaumcraftfix.ServerProxy", clientSide="thecodex6824.thaumcraftfix.ClientProxy")
    public static IProxy proxy;
    private Logger logger;
    private ThaumcraftFixNetworkHandler network;
    private ThaumcraftFixConfig config;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        proxy.construction();
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IOriginalAuraInfo.class, (Capability.IStorage)new Capability.IStorage<IOriginalAuraInfo>(){

            public void readNBT(Capability<IOriginalAuraInfo> capability, IOriginalAuraInfo instance, EnumFacing side, NBTBase nbt) {
                if (!(instance instanceof OriginalAuraInfo) || !(nbt instanceof NBTTagCompound)) {
                    throw new UnsupportedOperationException("Can't deserialize non-API implementation");
                }
                ((OriginalAuraInfo)instance).deserializeNBT((NBTTagCompound)nbt);
            }

            @Nullable
            public NBTBase writeNBT(Capability<IOriginalAuraInfo> capability, IOriginalAuraInfo instance, EnumFacing side) {
                if (!(instance instanceof OriginalAuraInfo)) {
                    throw new UnsupportedOperationException("Can't serialize non-API implementation");
                }
                return ((OriginalAuraInfo)instance).serializeNBT();
            }
        }, OriginalAuraInfo::new);
        CapabilityManager.INSTANCE.register(IAuraProcessor.class, (Capability.IStorage)new Capability.IStorage<IAuraProcessor>(){

            public void readNBT(Capability<IAuraProcessor> capability, IAuraProcessor instance, EnumFacing side, NBTBase nbt) {
                if (instance instanceof INBTSerializable) {
                    ((INBTSerializable)instance).deserializeNBT((NBTBase)((NBTTagCompound)nbt));
                }
            }

            @Nullable
            public NBTBase writeNBT(Capability<IAuraProcessor> capability, IAuraProcessor instance, EnumFacing side) {
                if (instance instanceof INBTSerializable) {
                    return ((INBTSerializable)instance).serializeNBT();
                }
                return new NBTTagCompound();
            }
        }, DefaultAuraProcessor::new);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.config = new ThaumcraftFixConfig();
        this.config.bind();
        ThaumcraftFixApiBridge.setImplementation(new DefaultApiImplementation());
        this.registerCapabilities();
        ResearchApi.registerScanParser(new ScanParserBlock(), 1000);
        ResearchApi.registerScanParser(new ScanParserItem(), 1000);
        ResearchApi.registerScanParser(new ScanParserItemExtended(), 1000);
        ResearchApi.registerScanParser(new ScanParserEntity(), 1000);
        ResearchApi.registerResearchEntrySource(Paths.get("config", "thaumcraftfix", "entries"));
        ResearchApi.registerResearchPatchSource(Paths.get("config", "thaumcraftfix", "patches"), 1000);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/alchemy.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/artifice.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/auromancy.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/basics.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/eldritch.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/golemancy.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/infusion.json"), -1);
        ResearchApi.registerResearchPatchSource(new ResourceLocation("thaumcraftfix", "research/patches/scans.json"), -1);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void afterThaumcraftRegistersItems(RegistryEvent<Item> event) {
        try {
            Class.forName("thaumcraft.common.golems.GolemProperties");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.network = new ThaumcraftFixNetworkHandler();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new AuraFinalizerWorldGenerator(), (int)Integer.MAX_VALUE);
        boolean errors = ResearchConfigParser.loadCategories();
        errors |= ResearchConfigParser.loadScans();
        if (errors |= ResearchConfigParser.loadAdvancements()) {
            this.logger.error("One or more research errors have occurred. Please check the log file for more information.");
        }
    }

    private static void setToolMaterialRepairItem(Item.ToolMaterial material, ItemStack repair) {
        try {
            material.setRepairItem(repair);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void setArmorMaterialRepairItem(ItemArmor.ArmorMaterial material, ItemStack repair) {
        try {
            material.setRepairItem(repair);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void registerEntityAspects(String entityName, AspectList aspectList) {
        ThaumcraftApi.registerEntityTag((String)entityName, (AspectList)aspectList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ThaumcraftFixApiBridge.implementation().reloadConfig();
        ThaumcraftFix.setToolMaterialRepairItem(ThaumcraftMaterials.TOOLMAT_ELEMENTAL, new ItemStack(ItemsTC.ingots, 1, 0));
        ThaumcraftFix.setToolMaterialRepairItem(ThaumcraftMaterials.TOOLMAT_THAUMIUM, new ItemStack(ItemsTC.ingots, 1, 0));
        ThaumcraftFix.setToolMaterialRepairItem(ThaumcraftMaterials.TOOLMAT_VOID, new ItemStack(ItemsTC.ingots, 1, 1));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_CULTIST_LEADER, new ItemStack(Items.field_151042_j));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_CULTIST_PLATE, new ItemStack(Items.field_151042_j));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_CULTIST_ROBE, new ItemStack(Items.field_151042_j));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_FORTRESS, new ItemStack(ItemsTC.ingots, 1, 0));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_THAUMIUM, new ItemStack(ItemsTC.ingots, 1, 0));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_VOID, new ItemStack(ItemsTC.ingots, 1, 1));
        ThaumcraftFix.setArmorMaterialRepairItem(ThaumcraftMaterials.ARMORMAT_VOIDROBE, new ItemStack(ItemsTC.ingots, 1, 1));
        ThaumcraftFix.registerEntityAspects("ArcaneBore", new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.TOOL, 10).add(Aspect.MAGIC, 10).add(Aspect.ENTROPY, 10));
        ThaumcraftFix.registerEntityAspects("TurretBasic", new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.AVERSION, 10).add(Aspect.MAGIC, 10));
        ThaumcraftFix.registerEntityAspects("TurretAdvanced", new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.AVERSION, 10).add(Aspect.MAGIC, 10).add(Aspect.MIND, 10));
        ThaumcraftFix.registerEntityAspects("TaintCrawler", new AspectList().add(Aspect.FLUX, 5).add(Aspect.BEAST, 5));
        ThaumcraftFix.registerEntityAspects("CultistPortalLesser", new AspectList().add(Aspect.AURA, 20).add(Aspect.ELDRITCH, 20).add(Aspect.AVERSION, 20));
        ThaumcraftFix.registerEntityAspects("CultistPortalGreater", new AspectList().add(Aspect.AURA, 40).add(Aspect.ELDRITCH, 40).add(Aspect.AVERSION, 40));
        ThaumcraftFix.registerEntityAspects("Grapple", new AspectList().add(Aspect.MECHANISM, 5).add(Aspect.MAGIC, 5).add(Aspect.TRAP, 5));
        ThaumcraftFix.registerEntityAspects("GolemDart", new AspectList().add(Aspect.AVERSION, 5).add(Aspect.MOTION, 5));
        ThaumcraftFix.registerEntityAspects("Alumentum", new AspectList().add(Aspect.ENERGY, 10).add(Aspect.FIRE, 10).add(Aspect.ENTROPY, 5).add(Aspect.MOTION, 5));
        ThaumcraftFix.registerEntityAspects("CausalityCollapser", new AspectList().add(Aspect.ENERGY, 40).add(Aspect.FIRE, 40).add(Aspect.ENTROPY, 20).add(Aspect.MOTION, 5).add(Aspect.ELDRITCH, 10));
        ThaumcraftFix.registerEntityAspects("BottleTaint", new AspectList().add(Aspect.FLUX, 15).add(Aspect.WATER, 5).add(Aspect.MOTION, 5));
        ThaumcraftFix.registerEntityAspects("FallingTaint", new AspectList().add(Aspect.MOTION, 5).add(Aspect.FLUX, 5));
        ThaumcraftFix.registerEntityAspects("EldritchOrb", new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.MOTION, 5).add(Aspect.AVERSION, 5));
        ThaumcraftFix.registerEntityAspects("GolemOrb", new AspectList().add(Aspect.ENERGY, 5).add(Aspect.MOTION, 5).add(Aspect.AVERSION, 5));
        ThaumcraftFix.registerEntityAspects("FocusCloud", new AspectList().add(Aspect.AURA, 10).add(Aspect.MAGIC, 10).add(Aspect.ALCHEMY, 10));
        ThaumcraftFix.registerEntityAspects("Focusmine", new AspectList().add(Aspect.AURA, 10).add(Aspect.MAGIC, 10).add(Aspect.TRAP, 10));
        ThaumcraftFix.registerEntityAspects("FocusProjectile", new AspectList().add(Aspect.AURA, 10).add(Aspect.MAGIC, 10).add(Aspect.MOTION, 10));
        EntityEntry spellbat = EntityRegistry.getEntry(EntitySpellBat.class);
        if (spellbat != null) {
            spellbat.setEgg(null);
            EntityList.field_75627_a.remove(spellbat.getRegistryName());
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        ThaumcraftFixApiBridge.InternalImplementation impl = ThaumcraftFixApiBridge.implementation();
        if (impl instanceof DefaultApiImplementation) {
            ImmutableSet.Builder allowed = ImmutableSet.builder();
            ArrayList<ResearchCategory> empty = new ArrayList<ResearchCategory>();
            for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
                if (category.research.isEmpty()) {
                    empty.add(category);
                }
                for (ResearchEntry entry : category.research.values()) {
                    if (entry.getStages() == null) continue;
                    for (ResearchStage stage : entry.getStages()) {
                        if (stage.getKnow() == null) continue;
                        for (ResearchStage.Knowledge know : stage.getKnow()) {
                            if (know.type != IPlayerKnowledge.EnumKnowledgeType.THEORY || know.category == null) continue;
                            allowed.add((Object)know.category);
                        }
                    }
                }
            }
            ((DefaultApiImplementation)impl).setAllowedTheorycraftCategories((ImmutableSet<ResearchCategory>)allowed.build());
            this.logger.debug("The following research categories will be allowed for theorycrafting:");
            for (ResearchCategory c : ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories()) {
                this.logger.debug("{}", (Object)c.key);
            }
            if (!empty.isEmpty()) {
                this.logger.debug("The following research categories will be removed from the game (including their Thaumonomicon tab):");
                for (ResearchCategory c : empty) {
                    this.logger.debug("{}", (Object)c.key);
                    ResearchCategories.researchCategories.remove(c.key);
                }
            }
        }
    }

    @Mod.EventHandler
    public static void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            Logger tempLogger = LogManager.getLogger((String)"thaumcraftfix");
            tempLogger.warn("A file failed to match with the signing key.");
            tempLogger.warn("If you *know* this is a homebrew/custom build then this is expected, carry on.");
            tempLogger.warn("Otherwise, you might want to redownload this mod from the *official* CurseForge page.");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SimpleNetworkWrapper getNetworkHandler() {
        return this.network;
    }

    public ThaumcraftFixConfig getConfig() {
        return this.config;
    }
}

