/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.event;

import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.Part;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.lib.crafting.DustTriggerMultiblock;
import thaumcraft.common.lib.events.PlayerEvents;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.aura.CapabilityOriginalAuraInfo;
import thecodex6824.thaumcraftfix.api.aura.IOriginalAuraInfo;
import thecodex6824.thaumcraftfix.api.aura.OriginalAuraInfo;
import thecodex6824.thaumcraftfix.common.network.PacketConfigSync;
import thecodex6824.thaumcraftfix.common.util.SimpleCapabilityProvider;

@Mod.EventBusSubscriber(modid="thaumcraftfix")
public class CommonEventHandler {
    private static Field TRIGGER_RESEARCH = null;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            PacketConfigSync packet = new PacketConfigSync(ThaumcraftFix.instance.getConfig().serializeNetwork());
            ThaumcraftFix.instance.getNetworkHandler().sendTo((IMessage)packet, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onFallFirst(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.field_76379_h) {
            LivingHurtEvent fakeEvent = new LivingHurtEvent(event.getEntityLiving(), event.getSource(), event.getAmount());
            PlayerEvents.onFallDamage((LivingHurtEvent)fakeEvent);
            if (fakeEvent.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilityChunk(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("thaumcraftfix", "original_aura_info"), new SimpleCapabilityProvider<IOriginalAuraInfo>(new OriginalAuraInfo(), CapabilityOriginalAuraInfo.AURA_INFO));
    }

    private static String getDustTriggerResearch(DustTriggerMultiblock trigger) {
        try {
            if (TRIGGER_RESEARCH == null) {
                TRIGGER_RESEARCH = DustTriggerMultiblock.class.getDeclaredField("research");
                TRIGGER_RESEARCH.setAccessible(true);
            }
            return (String)TRIGGER_RESEARCH.get(trigger);
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to access or invoke Thaumcraft's DustTriggerMultiblock#research", true);
            return null;
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        Part matrix = new Part((Object)BlocksTC.infusionMatrix, null);
        Part ancientStone = new Part((Object)BlocksTC.stoneAncient, (Object)"AIR");
        Part ancientPillarEast = new Part((Object)BlocksTC.stoneAncient, (Object)new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.EAST)));
        Part ancientPillarNorth = new Part((Object)BlocksTC.stoneAncient, (Object)new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.NORTH)));
        Part ancientPillarSouth = new Part((Object)BlocksTC.stoneAncient, (Object)new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.SOUTH)));
        Part ancientPillarWest = new Part((Object)BlocksTC.stoneAncient, (Object)new ItemStack(BlocksTC.pillarAncient, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.WEST)));
        Part ancientPedestal = new Part((Object)BlocksTC.pedestalAncient, null);
        Part[][][] ancientBlueprint = new Part[][][]{{{null, null, null}, {null, matrix, null}, {null, null, null}}, {{ancientStone, null, ancientStone}, {null, null, null}, {ancientStone, null, ancientStone}}, {{ancientPillarEast, null, ancientPillarNorth}, {null, ancientPedestal, null}, {ancientPillarSouth, null, ancientPillarWest}}};
        for (int i = 0; i < IDustTrigger.triggers.size(); ++i) {
            IDustTrigger trigger = (IDustTrigger)IDustTrigger.triggers.get(i);
            if (!(trigger instanceof DustTriggerMultiblock) || !CommonEventHandler.getDustTriggerResearch((DustTriggerMultiblock)trigger).equals("INFUSIONANCIENT")) continue;
            IDustTrigger.triggers.remove(i);
            break;
        }
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("INFUSIONANCIENT", (Part[][][])ancientBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)new ResourceLocation("thaumcraft", "infusionaltarancient"), (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("INFUSIONANCIENT", (Part[][][])ancientBlueprint, new ItemStack[]{new ItemStack(BlocksTC.stoneAncient, 8), new ItemStack(BlocksTC.pedestalAncient), new ItemStack(BlocksTC.infusionMatrix)}));
        Part eldritchStone = new Part((Object)BlocksTC.stoneEldritchTile, (Object)"AIR");
        Part eldritchPillarEast = new Part((Object)BlocksTC.stoneEldritchTile, (Object)new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.EAST)));
        Part eldritchPillarNorth = new Part((Object)BlocksTC.stoneEldritchTile, (Object)new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.NORTH)));
        Part eldritchPillarSouth = new Part((Object)BlocksTC.stoneEldritchTile, (Object)new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.SOUTH)));
        Part eldritchPillarWest = new Part((Object)BlocksTC.stoneEldritchTile, (Object)new ItemStack(BlocksTC.pillarEldritch, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.WEST)));
        Part eldritchPedestal = new Part((Object)BlocksTC.pedestalEldritch, null);
        Part[][][] eldritchBlueprint = new Part[][][]{{{null, null, null}, {null, matrix, null}, {null, null, null}}, {{eldritchStone, null, eldritchStone}, {null, null, null}, {eldritchStone, null, eldritchStone}}, {{eldritchPillarEast, null, eldritchPillarNorth}, {null, eldritchPedestal, null}, {eldritchPillarSouth, null, eldritchPillarWest}}};
        for (int i = 0; i < IDustTrigger.triggers.size(); ++i) {
            IDustTrigger trigger = (IDustTrigger)IDustTrigger.triggers.get(i);
            if (!(trigger instanceof DustTriggerMultiblock) || !CommonEventHandler.getDustTriggerResearch((DustTriggerMultiblock)trigger).equals("INFUSIONELDRITCH")) continue;
            IDustTrigger.triggers.remove(i);
            break;
        }
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("INFUSIONELDRITCH", (Part[][][])eldritchBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)new ResourceLocation("thaumcraft", "infusionaltareldritch"), (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("INFUSIONELDRITCH", (Part[][][])eldritchBlueprint, new ItemStack[]{new ItemStack(BlocksTC.stoneEldritchTile, 8), new ItemStack(BlocksTC.pedestalEldritch), new ItemStack(BlocksTC.infusionMatrix)}));
    }
}

