/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategory;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.internal.ThaumcraftFixApiBridge;
import thecodex6824.thaumcraftfix.api.scan.IScanParser;
import thecodex6824.thaumcraftfix.common.config.ThaumcraftFixConfig;

public class DefaultApiImplementation
implements ThaumcraftFixApiBridge.InternalImplementation {
    private ImmutableSet<ResearchCategory> allowedForTheorycraft = ImmutableSet.of();
    private ImmutableSet<String> allowedForTheorycraftKeys = ImmutableSet.of();
    private boolean controlAura = false;
    private boolean controlCrystals = false;
    private boolean controlTrees = false;
    private ImmutableSet<Biome> auraBiomes = ImmutableSet.of();
    private ImmutableSet<DimensionType> auraDims = ImmutableSet.of();
    private ImmutableSet<Biome> crystalBiomes = ImmutableSet.of();
    private ImmutableSet<DimensionType> crystalDims = ImmutableSet.of();
    private ImmutableSet<Biome> treeBiomes = ImmutableSet.of();
    private ImmutableSet<DimensionType> treeDims = ImmutableSet.of();
    private Multimap<Integer, IScanParser> scanParsers = MultimapBuilder.treeKeys().hashSetValues().build();
    private HashSet<Path> entrySources = new HashSet();
    private Multimap<Integer, ThaumcraftFixApiBridge.InternalImplementation.ResearchPatchSource> patchSources = MultimapBuilder.treeKeys().hashSetValues().build();

    private ImmutableSet<Biome> makeFilteredBiomeSet(Set<Biome> allBiomes, String[] filter, boolean allow) {
        ArrayList<Pattern> filterPatterns = new ArrayList<Pattern>();
        for (String p : filter) {
            try {
                filterPatterns.add(Pattern.compile(p));
            }
            catch (PatternSyntaxException ex) {
                ThaumcraftFix.instance.getLogger().error("A biome filter regex in the config is invalid: " + p, (Throwable)ex);
            }
        }
        return ImmutableSet.copyOf(allow ? allBiomes.stream().filter(b -> filterPatterns.stream().anyMatch(p -> p.matcher(b.getRegistryName().toString()).matches())).iterator() : allBiomes.stream().filter(b -> !filterPatterns.stream().anyMatch(p -> p.matcher(b.getRegistryName().toString()).matches())).iterator());
    }

    private ImmutableSet<DimensionType> makeFilteredDimensionSet(Set<DimensionType> allDims, String[] filter, boolean allow) {
        ArrayList<Pattern> filterPatterns = new ArrayList<Pattern>();
        for (String p : filter) {
            try {
                filterPatterns.add(Pattern.compile(p));
            }
            catch (PatternSyntaxException ex) {
                ThaumcraftFix.instance.getLogger().error("A biome filter regex in the config is invalid: " + p, (Throwable)ex);
            }
        }
        return ImmutableSet.copyOf(allow ? allDims.stream().filter(d -> filterPatterns.stream().anyMatch(p -> p.matcher(d.func_186065_b()).matches())).iterator() : allDims.stream().filter(d -> !filterPatterns.stream().anyMatch(p -> p.matcher(d.func_186065_b()).matches())).iterator());
    }

    @Override
    public void reloadConfig() {
        ThaumcraftFixConfig config = ThaumcraftFix.instance.getConfig();
        this.controlAura = config.world.aura.controlAura.value();
        this.controlCrystals = config.world.crystals.controlCrystals.value();
        this.controlTrees = config.world.vegetation.controlVegetation.value();
        ImmutableSet allBiomes = ImmutableSet.copyOf((Iterator)Biome.field_185377_q.iterator());
        ImmutableSet allDims = ImmutableSet.copyOf((Object[])DimensionType.values());
        this.auraBiomes = this.makeFilteredBiomeSet((Set<Biome>)allBiomes, config.world.aura.biomeList.value(), config.world.aura.biomeAllowList.value());
        this.auraDims = this.makeFilteredDimensionSet((Set<DimensionType>)allDims, config.world.aura.dimList.value(), config.world.aura.dimAllowList.value());
        this.crystalBiomes = this.makeFilteredBiomeSet((Set<Biome>)allBiomes, config.world.crystals.biomeList.value(), config.world.crystals.biomeAllowList.value());
        this.crystalDims = this.makeFilteredDimensionSet((Set<DimensionType>)allDims, config.world.crystals.dimList.value(), config.world.crystals.dimAllowList.value());
        this.treeBiomes = this.makeFilteredBiomeSet((Set<Biome>)allBiomes, config.world.vegetation.biomeList.value(), config.world.vegetation.biomeAllowList.value());
        this.treeDims = this.makeFilteredDimensionSet((Set<DimensionType>)allDims, config.world.vegetation.dimList.value(), config.world.vegetation.dimAllowList.value());
    }

    @Override
    public Set<ResearchCategory> getAllowedTheorycraftCategories() {
        return this.allowedForTheorycraft;
    }

    @Override
    public Set<String> getAllowedTheorycraftCategoryKeys() {
        return this.allowedForTheorycraftKeys;
    }

    public void setAllowedTheorycraftCategories(ImmutableSet<ResearchCategory> allowed) {
        this.allowedForTheorycraft = allowed;
        this.allowedForTheorycraftKeys = (ImmutableSet)this.allowedForTheorycraft.stream().map(c -> c.key).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean isControllingAuraGen() {
        return this.controlAura;
    }

    @Override
    public void setControlAuraGen(boolean handle) {
        this.controlAura = handle;
    }

    @Override
    public Set<Biome> auraAllowedBiomes() {
        return this.auraBiomes;
    }

    @Override
    public Set<DimensionType> auraAllowedDimensions() {
        return this.auraDims;
    }

    @Override
    public boolean isControllingCrystalGen() {
        return this.controlCrystals;
    }

    @Override
    public void setControlCrystalGen(boolean handle) {
        this.controlCrystals = handle;
    }

    @Override
    public Set<Biome> crystalAllowedBiomes() {
        return this.crystalBiomes;
    }

    @Override
    public Set<DimensionType> crystalAllowedDimensions() {
        return this.crystalDims;
    }

    @Override
    public boolean isControllingVegetationGen() {
        return this.controlTrees;
    }

    @Override
    public void setControlVegetationGen(boolean handle) {
        this.controlTrees = handle;
    }

    @Override
    public Set<Biome> vegetationAllowedBiomes() {
        return this.treeBiomes;
    }

    @Override
    public Set<DimensionType> vegetationAllowedDimensions() {
        return this.treeDims;
    }

    @Override
    public void registerScanParser(IScanParser parser, int weight) {
        this.scanParsers.put((Object)weight, (Object)parser);
    }

    @Override
    public Collection<IScanThing> parseScans(String key, ResourceLocation type, JsonElement data) {
        RuntimeException throwLater = new RuntimeException("No parsers were able to load scan of type " + type);
        for (IScanParser parser : this.scanParsers.values()) {
            if (!parser.matches(type)) continue;
            try {
                return parser.parseScan(key, type, data);
            }
            catch (Exception ex) {
                throwLater.addSuppressed(ex);
            }
        }
        throw throwLater;
    }

    @Override
    public void registerResearchEntrySource(Path path) {
        if (path.isAbsolute() || path.getRoot() != null) {
            throw new IllegalArgumentException("Filesystem research entry sources must be relative to the game directory");
        }
        this.entrySources.add(ThaumcraftFix.proxy.getGameDirectory().toPath().resolve(path.normalize()));
    }

    @Override
    public void registerResearchEntrySource(ResourceLocation loc) {
        ThaumcraftApi.registerResearchLocation((ResourceLocation)loc);
    }

    private ResourceLocation createFilesystemLocation(String path) {
        return new ResourceLocation("thaumcraftfix", "$filesystem:" + path);
    }

    @Override
    public Collection<ResourceLocation> getFilesystemResearchEntrySources() {
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        for (Path p : this.entrySources) {
            File file = p.toFile();
            if (!file.exists()) continue;
            if (file.isFile()) {
                locs.add(this.createFilesystemLocation(p.toString()));
                continue;
            }
            for (File f2 : file.listFiles(f -> f.isFile() && f.getName().endsWith(".json"))) {
                locs.add(this.createFilesystemLocation(f2.getPath()));
            }
        }
        return locs;
    }

    @Override
    public void registerResearchPatchSource(ResourceLocation loc, int weight) {
        this.patchSources.put((Object)weight, (Object)new ResourceLocationSource(loc));
    }

    @Override
    public void registerResearchPathSource(Path path, int weight) {
        this.patchSources.put((Object)weight, (Object)new FilesystemSource(path));
    }

    @Override
    public Collection<ThaumcraftFixApiBridge.InternalImplementation.ResearchPatchSource> getResearchPatchSources() {
        return this.patchSources.values();
    }

    private static class FilesystemSource
    implements ThaumcraftFixApiBridge.InternalImplementation.ResearchPatchSource {
        private final Path path;

        public FilesystemSource(Path p) {
            this.path = p;
        }

        @Override
        public String getDescriptor() {
            return this.path.toString();
        }

        @Override
        public Map<String, ? extends InputStream> open() throws IOException {
            File file = this.path.toFile();
            if (file.exists()) {
                if (file.isFile()) {
                    return ImmutableMap.of((Object)this.path.getFileName().toString(), (Object)new FileInputStream(file));
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (File f2 : file.listFiles(f -> f.isFile() && f.getName().endsWith(".json"))) {
                    builder.put((Object)f2.getName(), (Object)new FileInputStream(f2));
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass() && this.path.equals(((FilesystemSource)obj).path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    private static class ResourceLocationSource
    implements ThaumcraftFixApiBridge.InternalImplementation.ResearchPatchSource {
        private final ResourceLocation loc;

        public ResourceLocationSource(ResourceLocation location) {
            this.loc = location;
        }

        @Override
        public String getDescriptor() {
            return this.loc.toString();
        }

        @Override
        public Map<String, ? extends InputStream> open() throws IOException {
            return ImmutableMap.of((Object)this.loc.toString(), (Object)ThaumcraftFix.proxy.resolveResource(this.loc));
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass() && this.loc.equals((Object)((ResourceLocationSource)obj).loc);
        }

        public int hashCode() {
            return this.loc.hashCode();
        }
    }
}

