/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.research;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;

public class AdvancementResearchInfo {
    protected ResourceLocation advancementKey;
    protected List<String> researchKeys;
    protected Optional<String> researchMessage;

    public AdvancementResearchInfo(JsonObject input) throws JsonSchemaException {
        this.advancementKey = new ResourceLocation(JsonUtils.getOrThrow("key", input).getAsString());
        JsonElement research = JsonUtils.getOrThrow("research", input, this.advancementKey.toString());
        ImmutableList.Builder builder = ImmutableList.builder();
        if (research.isJsonObject()) {
            throw new JsonSchemaException("Research must be an array or single entry");
        }
        if (research.isJsonArray()) {
            for (JsonElement e : research.getAsJsonArray()) {
                if (!e.isJsonPrimitive()) {
                    throw new JsonSchemaException("Research array element must be a string");
                }
                builder.add((Object)e.getAsString());
            }
        } else {
            builder.add((Object)research.getAsString());
        }
        this.researchKeys = builder.build();
        JsonElement message = (JsonElement)JsonUtils.tryGet("message", input).orNull();
        if (message != null) {
            if (!message.isJsonPrimitive()) {
                throw new JsonSchemaException("Research message must be a string");
            }
            this.researchMessage = Optional.of(message.getAsString());
        }
    }

    public ResourceLocation getAdvancementKey() {
        return this.advancementKey;
    }

    public Collection<String> getResearchKeys() {
        return this.researchKeys;
    }

    public Optional<String> getResearchMessage() {
        return this.researchMessage;
    }
}

