/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.research.parser;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ScanItem;
import thecodex6824.thaumcraftfix.api.scan.IScanParser;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;
import thecodex6824.thaumcraftfix.common.research.ScanItemExtended;

public class ScanParserItemExtended
implements IScanParser {
    protected IScanThing parseElement(String key, JsonElement e) {
        int meta;
        if (e.isJsonArray()) {
            throw new JsonSchemaException("Invalid object entry: must be object or primitive");
        }
        if (e.isJsonPrimitive()) {
            ResourceLocation loc = new ResourceLocation(e.getAsString());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
            if (item == null) {
                throw new NullPointerException(key + ": Item " + loc + " does not exist");
            }
            return new ScanItem(key, new ItemStack(item, 1, Short.MAX_VALUE));
        }
        ResourceLocation loc = new ResourceLocation(JsonUtils.getPrimitiveOrThrow("name", e.getAsJsonObject()).getAsString());
        JsonPrimitive damage = (JsonPrimitive)JsonUtils.tryGetPrimitive("meta", e.getAsJsonObject()).orNull();
        JsonPrimitive strictVal = (JsonPrimitive)JsonUtils.tryGetPrimitive("strict", e.getAsJsonObject()).orNull();
        boolean strict = strictVal != null ? strictVal.getAsBoolean() : false;
        JsonElement nbt = (JsonElement)JsonUtils.tryGet("nbt", e.getAsJsonObject()).orNull();
        if (nbt != null && nbt.isJsonArray()) {
            throw new JsonSchemaException(key + ": nbt must be object or string");
        }
        JsonElement caps = (JsonElement)JsonUtils.tryGet("caps", e.getAsJsonObject()).orNull();
        if (caps != null && caps.isJsonArray()) {
            throw new JsonSchemaException(key + ": caps must be object or string");
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
        if (item == null) {
            throw new NullPointerException(key + ": Item " + loc + " does not exist");
        }
        int n = meta = strict ? 0 : Short.MAX_VALUE;
        if (damage != null) {
            try {
                meta = damage.getAsInt();
            }
            catch (NumberFormatException ex) {
                throw new JsonSchemaException(key + ": Meta value " + damage.getAsString() + " is not valid");
            }
        }
        NBTTagCompound capNbt = null;
        if (caps != null) {
            try {
                capNbt = JsonToNBT.func_180713_a((String)(caps.isJsonObject() ? new Gson().toJson((JsonElement)caps.getAsJsonObject()) : caps.getAsString()));
            }
            catch (NBTException ex) {
                throw new JsonSchemaException(key + ": Invalid caps nbt: " + (Object)((Object)ex));
            }
        }
        ItemStack stack = new ItemStack(item, 1, meta);
        if (nbt != null) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)(nbt.isJsonObject() ? new Gson().toJson((JsonElement)nbt.getAsJsonObject()) : nbt.getAsString())));
            }
            catch (NBTException ex) {
                throw new JsonSchemaException(key + ": Invalid nbt: " + (Object)((Object)ex));
            }
        }
        return new ScanItemExtended(key, stack, capNbt, strict);
    }

    @Override
    public boolean matches(ResourceLocation type) {
        return type.func_110624_b().equals("tcresearchpatcher") && type.func_110623_a().equals("item_extended");
    }

    @Override
    public Collection<IScanThing> parseScan(String key, ResourceLocation type, JsonElement input) {
        if (input.isJsonArray()) {
            ArrayList<IScanThing> things = new ArrayList<IScanThing>();
            for (JsonElement e : input.getAsJsonArray()) {
                things.add(this.parseElement(key, e));
            }
            return things;
        }
        return Lists.newArrayList((Object[])new IScanThing[]{this.parseElement(key, input)});
    }
}

