/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import com.google.common.collect.Streams;
import com.google.common.math.DoubleMath;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusMedium;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.common.container.ContainerArcaneWorkbench;
import thaumcraft.common.tiles.crafting.FocusElementNode;
import thaumcraft.common.tiles.crafting.TileArcaneWorkbench;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.devices.TileInfernalFurnace;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.LocalVariableDefinition;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;
import thecodex6824.thaumcraftfix.core.transformer.Types;
import thecodex6824.thaumcraftfix.core.transformer.custom.BlockApplyOffsetTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.ThrowingTransformerWrapper;

public class BlockTransformers {
    private static final String HOOKS_COMMON = Type.getInternalName(HooksCommon.class);
    @SideOnly(value=Side.CLIENT)
    private static final String HOOKS_CLIENT = Type.getInternalName(HooksClient.class);
    public static final Supplier<ITransformer> ARCANE_WORKBENCH_NO_CONCURRENT_USE = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/blocks/crafting/BlockArcaneWorkbench", false, "func_180639_a", Type.BOOLEAN_TYPE, Types.WORLD, Types.BLOCK_POS, Types.I_BLOCK_STATE, Types.ENTITY_PLAYER, Types.ENUM_HAND, Types.ENUM_FACING, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE))).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition(Types.WORLD.getInternalName(), "field_72995_K", Type.BOOLEAN_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new VarInsnNode(25, 4), new MethodInsnNode(184, HOOKS_COMMON, "isArcaneWorkbenchNotAllowed", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Types.WORLD, Types.BLOCK_POS, Types.ENTITY_PLAYER}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> ARCANE_WORKBENCH_NO_CONCURRENT_USE_CHARGER = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/blocks/crafting/BlockArcaneWorkbenchCharger", false, "func_180639_a", Type.BOOLEAN_TYPE, Types.WORLD, Types.BLOCK_POS, Types.I_BLOCK_STATE, Types.ENTITY_PLAYER, Types.ENUM_HAND, Types.ENUM_FACING, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE))).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition(Types.WORLD.getInternalName(), "field_72995_K", Type.BOOLEAN_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new VarInsnNode(25, 4), new MethodInsnNode(184, HOOKS_COMMON, "isArcaneWorkbenchNotAllowedForCharger", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Types.WORLD, Types.BLOCK_POS, Types.ENTITY_PLAYER}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> BRAIN_JAR_EAT_DELAY = () -> new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/tiles/devices/TileJarBrain", false, "func_73660_a", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextLocalAccess(new LocalVariableDefinition("ents", Types.LIST))).findNextMethodCall(new MethodDefinition("java/util/List", true, "iterator", Types.ITERATOR, new Type[0]))).findNextOpcode(58)).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new LdcInsnNode((Object)10), new FieldDefinition("thaumcraft/common/tiles/devices/TileJarBrain", "eatDelay", Type.INT_TYPE).asFieldInsnNode(181)}).build(), true, 1);
    public static final Supplier<ITransformer> FOCAL_MANIPULATOR_FOCUS_SLOT = () -> {
        FieldDefinition vis = new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "vis", Type.FLOAT_TYPE);
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), false, "func_70299_a", Type.VOID_TYPE, Type.INT_TYPE, Types.ITEM_STACK))).findNextFieldAccess(vis)).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(87), new VarInsnNode(25, 0), vis.asFieldInsnNode(180)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> FOCAL_MANIPULATOR_SERVER_CHECKS = () -> {
        LabelNode newLabel = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(new MethodDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), false, "startCraft", Type.BOOLEAN_TYPE, Type.INT_TYPE, Types.ENTITY_PLAYER)).findConsecutive().findNextOpcode(134)).findNextFieldAccess(new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "vis", Type.FLOAT_TYPE))).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(25, 2), new VarInsnNode(21, 3), new VarInsnNode(21, 4), new MethodInsnNode(184, HOOKS_COMMON, "checkFocus", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.TILE_FOCAL_MANIPULATOR, Types.ENTITY_PLAYER, Type.INT_TYPE, Type.INT_TYPE}), false), new JumpInsnNode(154, newLabel), new InsnNode(3), new InsnNode(172), newLabel, new FrameNode(3, 0, null, 0, null)}).build(), true, 1);
    };
    public static final ITransformer FOCAL_MANIPULATOR_COMPONENTS = new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(new MethodDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), false, "startCraft", Type.BOOLEAN_TYPE, Type.INT_TYPE, Types.ENTITY_PLAYER)).findConsecutive().findNextLocalAccess(6)).findNextOpcode(190)).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new InsnNode(89), new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "crystals", Type.getType((String)"Lthaumcraft/api/aspects/AspectList;")).asFieldInsnNode(180), new VarInsnNode(25, 2), new MethodInsnNode(184, HOOKS_COMMON, "modifyManipulatorComponentCount", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Types.TILE_FOCAL_MANIPULATOR, Type.getType((String)"Lthaumcraft/api/aspects/AspectList;"), Types.ENTITY_PLAYER}), false)}).build(), true, 1);
    private static final String GUI_MANIPULATOR_CLASS = "thaumcraft/client/gui/GuiFocalManipulator";
    public static final ITransformer FOCAL_MANIPULATOR_COMPONENTS_CLIENT = new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/client/gui/GuiFocalManipulator", false, "gatherInfo", Type.VOID_TYPE, Type.BOOLEAN_TYPE)).findNextFieldAccess(new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "valid", Type.BOOLEAN_TYPE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new InsnNode(89), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "valid", Type.BOOLEAN_TYPE).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "totalComplexity", Type.INT_TYPE).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "maxComplexity", Type.INT_TYPE).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "table", Types.TILE_FOCAL_MANIPULATOR).asFieldInsnNode(180), new VarInsnNode(21, 4), new VarInsnNode(21, 6), new MethodInsnNode(184, HOOKS_CLIENT, "modifyFocalManipulatorCraftValid", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Type.INT_TYPE, Type.INT_TYPE, Types.TILE_FOCAL_MANIPULATOR, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE}), false), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "valid", Type.BOOLEAN_TYPE).asFieldInsnNode(181)}).build());
    public static final Supplier<ITransformer> FOCAL_MANIPULATOR_EXCLUSIVE_NODES_CLIENT = () -> new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(new MethodDefinition(GUI_MANIPULATOR_CLASS, false, "gatherPartsList", Type.VOID_TYPE, new Type[0])).findConsecutive().findNextFieldAccess(new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "data", Types.HASH_MAP))).findNextMethodCall(new MethodDefinition(Types.HASH_MAP.getInternalName(), false, "values", Types.COLLECTION, new Type[0]))).findNextMethodCall(new MethodDefinition(Types.COLLECTION.getInternalName(), true, "iterator", Types.ITERATOR, new Type[0]))).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new FieldDefinition(GUI_MANIPULATOR_CLASS, "table", Types.TILE_FOCAL_MANIPULATOR).asFieldInsnNode(180), new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "data", Types.HASH_MAP).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition(GUI_MANIPULATOR_CLASS, "selectedNode", Type.INT_TYPE).asFieldInsnNode(180), new MethodInsnNode(184, HOOKS_COMMON, "getNodesInTree", Type.getMethodDescriptor((Type)Types.ITERATOR, (Type[])new Type[]{Types.ITERATOR, Types.HASH_MAP, Type.INT_TYPE}), false)}).build());
    public static final Supplier<ITransformer> FOCAL_MANIPULATOR_VIS_FP_ISSUES = () -> new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), false, "func_73660_a", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextLocalAccess(2)).findNextOpcode(102)).findNextFieldAccess(new FieldDefinition(Types.TILE_FOCAL_MANIPULATOR.getInternalName(), "vis", Type.FLOAT_TYPE))).endConsecutive().matchLastNodeOnly().insertInstructionsBefore(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS_COMMON, "handleFocalManipulatorVis", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE}), false)}).build());
    public static final ITransformer FOCAL_MANIPULATOR_XP_COST_GUI = new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/client/gui/GuiFocalManipulator", false, "gatherInfo", Type.VOID_TYPE, Type.BOOLEAN_TYPE)).findNextFieldAccess(new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "costXp", Type.INT_TYPE))).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(87), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/client/gui/GuiFocalManipulator", "totalComplexity", Type.INT_TYPE).asFieldInsnNode(180), new MethodInsnNode(184, HOOKS_COMMON, "recalcManipulatorXpCost", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false)}).build());
    public static final Supplier<ITransformer> INFERNAL_FURNACE_DESTROY_EFFECTS = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/tiles/devices/TileInfernalFurnace", false, "destroyItem", Type.VOID_TYPE, new Type[0]))).findNextOpcode(177)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodDefinition(HOOKS_COMMON, false, "destroyItemEffectsThatActuallyWork", Type.VOID_TYPE, Type.getType((String)"Lthaumcraft/common/tiles/devices/TileInfernalFurnace;")).asMethodInsnNode(184)}).build());
    public static final Supplier<ITransformer> INFERNAL_FURNACE_ITEM_CHECKS = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/blocks/devices/BlockInfernalFurnace", false, "func_180634_a", Type.VOID_TYPE, Types.WORLD, Types.BLOCK_POS, Types.I_BLOCK_STATE, Types.ENTITY))).findNextMethodCall(new MethodDefinition("thaumcraft/common/tiles/devices/TileInfernalFurnace", false, "addItemsToInventory", Types.ITEM_STACK, Types.ITEM_STACK))).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 4), new MethodDefinition(HOOKS_COMMON, false, "passStackToFurnace", Types.ITEM_STACK, Types.ITEM_STACK, Types.ENTITY).asMethodInsnNode(184)}).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ENTITY_ITEM.getInternalName(), false, "func_92058_a", Type.VOID_TYPE, Types.ITEM_STACK)))).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 4), new MethodDefinition(HOOKS_COMMON, false, "getStackToSet", Types.ITEM_STACK, Types.ITEM_STACK, Types.ENTITY).asMethodInsnNode(184)}).build());
    public static final Supplier<ITransformer> PLANT_CINDERPEARL_OFFSET = () -> new ThrowingTransformerWrapper(new BlockApplyOffsetTransformer("thaumcraft/common/blocks/world/plants/BlockPlantCinderpearl"));
    public static final Supplier<ITransformer> PLANT_SHIMMERLEAF_OFFSET = () -> new ThrowingTransformerWrapper(new BlockApplyOffsetTransformer("thaumcraft/common/blocks/world/plants/BlockPlantShimmerleaf"));
    public static final Supplier<ITransformer> TABLE_TOP_SOLID = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/blocks/basic/BlockTable", false, "func_193383_a", Types.BLOCK_FACE_SHAPE, Types.I_BLOCK_ACCESS, Types.I_BLOCK_STATE, Types.BLOCK_POS, Types.ENUM_FACING))).findNextOpcode(176)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 4), new MethodInsnNode(184, HOOKS_COMMON, "getTableBlockFaceShape", Type.getMethodDescriptor((Type)Types.BLOCK_FACE_SHAPE, (Type[])new Type[]{Types.BLOCK_FACE_SHAPE, Types.ENUM_FACING}), false)}).build());
    public static final Supplier<ITransformer> THAUMATORIUM_TOP_EMPTY = () -> {
        LabelNode jumpTarget = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/tiles/crafting/TileThaumatoriumTop", false, "func_191420_l", Type.BOOLEAN_TYPE, new Type[0]))).findConsecutive().findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/tiles/crafting/TileThaumatorium", false, "func_191420_l", Type.BOOLEAN_TYPE, new Type[0])))).findNextOpcode(172)).endConsecutive().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(89), new JumpInsnNode(198, jumpTarget)}).after(new AbstractInsnNode[]{jumpTarget, new FrameNode(4, 0, null, 1, new Object[]{"thaumcraft/common/tiles/crafting/TileThaumatorium"}), new InsnNode(87), new InsnNode(4), new InsnNode(172)}).endAction().build(), true, 1);
    };

    @SideOnly(value=Side.CLIENT)
    public static final class HooksClient {
        public static boolean modifyFocalManipulatorCraftValid(boolean origResult, int totalComplexity, int maxComplexity, TileFocalManipulator table, boolean emptyNodes, boolean validCrystals) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (!player.func_184812_l_()) {
                return origResult;
            }
            return totalComplexity <= maxComplexity && !emptyNodes;
        }
    }

    public static final class HooksCommon {
        public static int modifyManipulatorComponentCount(int originalCount, TileFocalManipulator tile, AspectList crystals, EntityPlayer crafter) {
            int result;
            int n = result = crafter.func_184812_l_() ? -1 : originalCount;
            if (result < 0) {
                tile.crystalsSync = crystals.copy();
            }
            return result;
        }

        public static int recalcManipulatorXpCost(int totalComplexity) {
            return (int)Math.max(1L, Math.round(Math.sqrt(totalComplexity)));
        }

        public static BlockFaceShape getTableBlockFaceShape(BlockFaceShape original, EnumFacing side) {
            return side == EnumFacing.UP && original == BlockFaceShape.UNDEFINED ? BlockFaceShape.SOLID : original;
        }

        public static boolean isArcaneWorkbenchNotAllowed(boolean original, World world, BlockPos pos, EntityPlayer player) {
            boolean notAllowed = original;
            if (!notAllowed) {
                TileEntity tile = world.func_175625_s(pos);
                boolean bl = notAllowed = !(tile instanceof TileArcaneWorkbench) || ((TileArcaneWorkbench)tile).inventoryCraft.field_70465_c instanceof ContainerArcaneWorkbench;
                if (notAllowed && player != null) {
                    player.func_146105_b(new TextComponentTranslation("thaumcraftfix.alreadyinuse", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
            return notAllowed;
        }

        public static boolean isArcaneWorkbenchNotAllowedForCharger(boolean original, World world, BlockPos pos, EntityPlayer player) {
            boolean notAllowed = original;
            if (!notAllowed) {
                BlockPos real = pos.func_177977_b();
                IBlockState state = world.func_180495_p(real);
                notAllowed = state.func_177230_c() == BlocksTC.arcaneWorkbench && HooksCommon.isArcaneWorkbenchNotAllowed(original, world, real, player);
            }
            return notAllowed;
        }

        public static Iterator<FocusElementNode> getNodesInTree(Iterator<FocusElementNode> nodeIterator, HashMap<Integer, FocusElementNode> allNodes, int selectedNode) {
            FocusElementNode original;
            Set allowedNodes = Collections.newSetFromMap(new IdentityHashMap());
            FocusElementNode cursor = original = allNodes.get(selectedNode);
            allowedNodes.add(cursor);
            while (cursor.parent != -1) {
                cursor = allNodes.get(cursor.parent);
                allowedNodes.add(cursor);
            }
            ArrayDeque<FocusElementNode> nodesStack = new ArrayDeque<FocusElementNode>();
            nodesStack.add(original);
            while (!nodesStack.isEmpty()) {
                FocusElementNode node = (FocusElementNode)nodesStack.pop();
                allowedNodes.add(node);
                for (int child : node.children) {
                    nodesStack.push(allNodes.get(child));
                }
            }
            return Streams.stream(nodeIterator).filter(allowedNodes::contains).iterator();
        }

        private static boolean canParentSupplyAll(FocusNode parent, FocusNode child) {
            for (FocusNode.EnumSupplyType type : child.mustBeSupplied()) {
                if (parent.canSupply(type)) continue;
                return false;
            }
            return true;
        }

        public static boolean checkFocus(TileFocalManipulator tile, EntityPlayer player, int maxComplexity, int computedComplexity) {
            boolean result = true;
            Logger logger = ThaumcraftFix.instance.getLogger();
            if (computedComplexity > maxComplexity) {
                result = false;
                logger.warn("Player {} ({}) tried to make a focus of complexity {} when the focus has a maximum complexity of {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)computedComplexity, (Object)maxComplexity);
            }
            if (result) {
                List leafNodes = tile.data.values().stream().filter(n -> n.children.length == 0).collect(Collectors.toList());
                block0: for (FocusElementNode leaf : leafNodes) {
                    boolean rootFound = false;
                    boolean mediumFound = false;
                    HashSet<String> bannedNodes = new HashSet<String>();
                    while (leaf != null && leaf.node != null) {
                        FocusElementNode directParent;
                        FocusElementNode focusElementNode = directParent = leaf.parent != -1 ? (FocusElementNode)tile.data.get(leaf.parent) : null;
                        if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{leaf.node.getResearch()})) {
                            result = false;
                            logger.warn("Player {} ({}) tried to make a focus without required research {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)leaf.node.getResearch());
                            continue block0;
                        }
                        if (directParent != null && directParent.node != null && !HooksCommon.canParentSupplyAll(directParent.node, leaf.node)) {
                            result = false;
                            logger.warn("Player {} ({}) tried to make a focus with an invalid parent -> child node combo {} -> {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)directParent.node.getKey(), (Object)leaf.node.getKey());
                            continue block0;
                        }
                        if (leaf.node.getKey().equals("ROOT")) {
                            if (rootFound) {
                                result = false;
                                logger.warn("Player {} ({}) tried to make a focus with multiple root nodes", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                                continue block0;
                            }
                            rootFound = true;
                        } else if (leaf.node instanceof FocusMedium && !bannedNodes.isEmpty() && leaf.node.isExclusive() && mediumFound) {
                            result = false;
                            logger.warn("Player {} ({}) tried to make a focus with illegal mediums", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                        } else {
                            if (leaf.node.isExclusive() && !bannedNodes.add(leaf.node.getKey())) {
                                result = false;
                                logger.warn("Player {} ({}) tried to make a focus with illegal nodes", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString());
                                continue block0;
                            }
                            if (leaf.node instanceof FocusMedium) {
                                mediumFound = true;
                            }
                        }
                        leaf = directParent;
                    }
                }
            }
            if (!result) {
                tile.vis = 0.0f;
            }
            return result;
        }

        public static float handleFocalManipulatorVis(float vis) {
            if (DoubleMath.fuzzyEquals((double)vis, (double)0.0, (double)1.0E-4)) {
                vis = 0.0f;
            }
            return vis;
        }

        public static ItemStack passStackToFurnace(ItemStack original, Entity item) {
            return item.field_70128_L ? ItemStack.field_190927_a : original;
        }

        public static ItemStack getStackToSet(ItemStack original, Entity item) {
            item.func_70106_y();
            return ((EntityItem)item).func_92059_d();
        }

        public static void destroyItemEffectsThatActuallyWork(TileInfernalFurnace furnace) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            BlockPos pos = furnace.func_174877_v();
            World world = furnace.func_145831_w();
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
            float pX = (float)pos.func_177958_n() + rand.nextFloat();
            float pY = (float)pos.func_177956_o() + 0.5f;
            float pZ = (float)pos.func_177952_p() + rand.nextFloat();
            SPacketParticles packet = new SPacketParticles(EnumParticleTypes.LAVA, false, pX, pY, pZ, 0.0f, 0.0f, 0.0f, 0.0f, rand.nextInt(3) + 2, new int[0]);
            for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                double dZ;
                double dY;
                double dX;
                if (player.field_71093_bK != world.field_73011_w.getDimension() || !((dX = (double)pX - player.field_70165_t) * dX + (dY = (double)pY - (player.field_70163_u + (double)player.eyeHeight)) * dY + (dZ = (double)pZ - player.field_70161_v) * dZ < 4096.0)) continue;
                player.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }
}

