/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.construct.EntityArcaneBore;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.utils.Utils;
import thecodex6824.coremodlib.FieldAccessType;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.MatchDetails;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.api.event.EntityInOuterLandsEvent;
import thecodex6824.thaumcraftfix.api.event.FluxRiftDestroyBlockEvent;
import thecodex6824.thaumcraftfix.common.util.NoEquipSoundFakePlayer;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;
import thecodex6824.thaumcraftfix.core.transformer.Types;
import thecodex6824.thaumcraftfix.core.transformer.custom.ChangeVariableTypeTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.EntityAspectPrefixRemoverTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.ThrowingTransformerWrapper;

public class EntityTransformers {
    private static final String HOOKS_COMMON = Type.getInternalName(HooksCommon.class);
    @SideOnly(value=Side.CLIENT)
    private static final String HOOKS_CLIENT = Type.getInternalName(HooksClient.class);
    public static final ITransformer ELDRITCH_GUARDIAN_FOG = new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/monster/EntityEldritchGuardian", false, "func_70071_h_", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextMethodCall(new MethodDefinition("net/minecraft/world/WorldProvider", false, "getDimension", Type.INT_TYPE, new Type[0]))).findNextFieldAccess(new FieldDefinition("thaumcraft/common/config/ModConfig$CONFIG_WORLD", "dimensionOuterId", Type.INT_TYPE))).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isInOuterLands", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Types.ENTITY}), false)}).build());
    public static final Supplier<ITransformer> ENTITY_ASPECTS = () -> new ThrowingTransformerWrapper(new EntityAspectPrefixRemoverTransformer());
    public static final Supplier<ITransformer> ADVANCED_CROSSBOW_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityTurretCrossbowAdvanced");
    public static final Supplier<ITransformer> BORE_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer(Types.ENTITY_ARCANE_BORE.getInternalName());
    public static final Supplier<ITransformer> CROSSBOW_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityTurretCrossbow");
    public static final Supplier<ITransformer> GOLEM_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/golems/EntityThaumcraftGolem");
    public static final Supplier<ITransformer> OWNED_CONSTRUCT_PROCESS_INTERACT_DEAD = EntityTransformers.makeEntityProcessInteractTransformer("thaumcraft/common/entities/construct/EntityOwnedConstruct");
    public static final Supplier<ITransformer> OWNED_CONSTRUCT_ZERO_DROP_CHANCES = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/entities/construct/EntityOwnedConstruct", false, "<init>", Type.VOID_TYPE, Types.WORLD)).findNextOpcode(177)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "clearDropChances", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_LIVING}), false)}).build());
    public static final Supplier<ITransformer> PECH_ADD_STACK = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/container/ContainerPech", false, "addStack", Type.VOID_TYPE, Types.ITEM_STACK)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ITEM_STACK.getInternalName(), false, "func_190917_f", Type.VOID_TYPE, Type.INT_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new InsnNode(177)}).build());
    public static final ITransformer VOID_ROBE_ARMOR_DISPLAY = new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/items/armor/ItemVoidRobeArmor", false, "getArmorDisplay", Type.INT_TYPE, Types.ENTITY_PLAYER, Types.ITEM_STACK, Type.INT_TYPE)).findNextOpcode(172)).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(3)}).build());
    public static final ITransformer FLUX_RIFT_DESTROY_BLOCK_EVENT = new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/EntityFluxRift", false, "func_70071_h_", Type.VOID_TYPE, new Type[0]))).findConsecutive().findNextLocalAccess(0)).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition("thaumcraft/common/entities/EntityFluxRift", "field_70170_p", Types.WORLD)))).findNextLocalAccess(5)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.WORLD.getInternalName(), false, "func_175623_d", Type.BOOLEAN_TYPE, Types.BLOCK_POS)))).findNextInstructionType(JumpInsnNode.class)).endConsecutive().insertInstructions((node, matches) -> {
        InsnList toAdd = new InsnList();
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toAdd.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_COMMON, "fireFluxRiftDestroyBlockEvent", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType((String)"Lthaumcraft/common/entities/EntityFluxRift;"), Types.BLOCK_POS, Types.I_BLOCK_STATE}), false));
        JumpInsnNode originalJump = (JumpInsnNode)((MatchDetails)matches.get(0)).matchEnd();
        toAdd.add((AbstractInsnNode)new JumpInsnNode(originalJump.getOpcode(), originalJump.label));
        ImmutableList added = ImmutableList.copyOf((Iterator)toAdd.iterator());
        node.instructions.insertBefore(((MatchDetails)matches.get(0)).matchStart(), toAdd);
        return added;
    }).build());
    public static final Supplier<ITransformer> BORE_FIX_RUMBLE_AND_LAMPLIGHT = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "dig", Type.BOOLEAN_TYPE, new Type[0])).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.WORLD.getInternalName(), false, "func_175698_g", Type.BOOLEAN_TYPE, Types.BLOCK_POS)))).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isBoreTargetAir", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.WORLD, Types.BLOCK_POS, Type.BOOLEAN_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).endAction().build());
    public static final Supplier<ITransformer> BORE_GUI_PROPERTIES = () -> {
        MethodDefinition hasSilkTouch = new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "hasSilkTouch", Type.BOOLEAN_TYPE, new Type[0]);
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/client/gui/GuiArcaneBore", false, "func_146976_a", Type.VOID_TYPE, Type.FLOAT_TYPE, Type.INT_TYPE, Type.INT_TYPE))).findNextMethodCall(hasSilkTouch)).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(89)}).after(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS_CLIENT, "doesBoreHaveProperties", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Type.BOOLEAN_TYPE}), false)}).endAction().findNextMethodCall(hasSilkTouch)).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(89), new VarInsnNode(21, 8), new MethodInsnNode(184, HOOKS_CLIENT, "drawLamplightText", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Type.INT_TYPE}), false), new VarInsnNode(54, 8)}).build());
    };
    public static final Supplier<ITransformer> BORE_NO_EQUIP_SOUND = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "dig", Type.BOOLEAN_TYPE, new Type[0])).findNextMethodCall(new MethodDefinition(Types.FAKE_PLAYER_FACTORY.getInternalName(), false, "get", Types.FAKE_PLAYER, Types.WORLD_SERVER, Types.GAME_PROFILE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "makeBoreFakePlayer", Type.getMethodDescriptor((Type)Types.FAKE_PLAYER, (Type[])new Type[]{Types.FAKE_PLAYER, Types.ENTITY_ARCANE_BORE}), false)}).build());
    public static final Supplier<ITransformer> BORE_PARTICLE_TEXTURE = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/client/fx/particles/FXBoreParticles", false, "<init>", Type.VOID_TYPE, Types.WORLD, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Types.I_BLOCK_STATE, Type.INT_TYPE)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/client/fx/particles/FXBoreParticles", false, "func_187117_a", Type.VOID_TYPE, Types.TEXTURE_ATLAS_SPRITE)))).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 14), new MethodInsnNode(184, HOOKS_CLIENT, "getBlockParticleTexture", Type.getMethodDescriptor((Type)Types.TEXTURE_ATLAS_SPRITE, (Type[])new Type[]{Types.TEXTURE_ATLAS_SPRITE, Types.I_BLOCK_STATE}), false)}).build());
    public static final Supplier<ITransformer> BORE_SPIRAL_TWEAKS = () -> {
        FieldDefinition currentRadius = new FieldDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), "currentRadius", Type.FLOAT_TYPE);
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), false, "findNextBlockToDig", Type.VOID_TYPE, new Type[0])).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityArcaneBore", false, "func_174831_c", Type.DOUBLE_TYPE, Types.BLOCK_POS)))).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS_COMMON, "getFixedDistanceSq", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Types.ENTITY_ARCANE_BORE, Types.BLOCK_POS, Type.DOUBLE_TYPE}), false)}).endAction().findNextFieldAccess(new FieldDefinition(Types.ENTITY_ARCANE_BORE.getInternalName(), "spiral", Type.INT_TYPE), FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modSpiral", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextFieldAccess(currentRadius, FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modCurrentRadius", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextFieldAccess(currentRadius, FieldAccessType.STORE)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modCurrentRadiusReset", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE, Types.ENTITY_ARCANE_BORE}), false)}).findNextMethodCall(new MethodDefinition("thaumcraft/common/lib/utils/Utils", false, "rotateAroundX", Types.VEC_3D, Types.VEC_3D, Type.FLOAT_TYPE))).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.VEC_3D.getInternalName(), false, "func_72441_c", Types.VEC_3D, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "modRotation", Type.getMethodDescriptor((Type)Types.VEC_3D, (Type[])new Type[]{Types.VEC_3D, Types.ENTITY_ARCANE_BORE}), false)}).build());
    };
    public static final Supplier<ITransformer> CROSSBOW_FIRE_ARROW_CLASS = () -> new ThrowingTransformerWrapper(new ChangeVariableTypeTransformer(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_82196_d", Type.VOID_TYPE, Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE)), Types.ENTITY_TIPPED_ARROW, Types.ENTITY_ARROW, false, (Collection<String>)ImmutableSet.of((Object)TransformUtil.remapMethod(new MethodDefinition(Types.ENTITY_TIPPED_ARROW.getInternalName(), false, "func_184555_a", Type.VOID_TYPE, Types.ITEM_STACK)).name()), true));
    public static final Supplier<ITransformer> CROSSBOW_FIRE_ARROW_LOGIC = () -> {
        LabelNode afterArrowCreation = new LabelNode(new Label());
        LabelNode afterShrink = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_82196_d", Type.VOID_TYPE, Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE))).findNextNewObject(Types.ENTITY_TIPPED_ARROW)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ENTITY_TIPPED_ARROW.getInternalName(), false, "func_184555_a", Type.VOID_TYPE, Types.ITEM_STACK)))).combineLastTwoMatches().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(23, 2), new MethodInsnNode(184, HOOKS_COMMON, "fireArrow", Type.getMethodDescriptor((Type)Types.ENTITY_ARROW, (Type[])new Type[]{Types.ENTITY_LIVING_BASE, Type.FLOAT_TYPE}), false), new InsnNode(89), new JumpInsnNode(199, afterArrowCreation)}).after(new AbstractInsnNode[]{afterArrowCreation, new FrameNode(4, 0, null, 1, new Object[]{Types.ENTITY_ARROW.getInternalName()}), new VarInsnNode(58, 3)}).endAction().findConsecutive().findNextLocalAccess(0)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/entities/construct/EntityTurretCrossbow", false, "func_184614_ca", Types.ITEM_STACK, new Type[0])))).findAny()).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.ITEM_STACK.getInternalName(), false, "func_190918_g", Type.VOID_TYPE, Type.INT_TYPE)))).endConsecutive().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isArrowInfinite", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.ENTITY_LIVING_BASE}), false), new JumpInsnNode(154, afterShrink)}).after(new AbstractInsnNode[]{afterShrink, new FrameNode(3, 0, null, 0, null)}).endAction().build(), true, 1);
    };

    private static Supplier<ITransformer> makeEntityProcessInteractTransformer(String className) {
        return () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition(className, false, "func_184645_a", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.ENUM_HAND))).findNextFieldAccess(TransformUtil.remapField(new FieldDefinition(className, "field_70128_L", Type.BOOLEAN_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodInsnNode(184, HOOKS_COMMON, "isEntityDeadForProcessInteract", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Types.ENTITY_LIVING_BASE}), false)}).build());
    }

    @SideOnly(value=Side.CLIENT)
    public static final class HooksClient {
        public static TextureAtlasSprite getBlockParticleTexture(TextureAtlasSprite old, IBlockState state) {
            return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e();
        }

        private static boolean boreHasLamplighter(EntityArcaneBore bore) {
            ItemStack held = bore.func_184614_ca();
            return !held.func_190926_b() && EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)held, (EnumInfusionEnchantment)EnumInfusionEnchantment.LAMPLIGHT) > 0;
        }

        public static boolean doesBoreHaveProperties(EntityArcaneBore bore, boolean original) {
            return original || HooksClient.boreHasLamplighter(bore);
        }

        public static int drawLamplightText(EntityArcaneBore bore, int position) {
            if (HooksClient.boreHasLamplighter(bore)) {
                String text = I18n.func_135052_a((String)"enchantment.infusion.LAMPLIGHT", (Object[])new Object[0]);
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text, 4.0f, (float)(34 + position), 0xFFFF00);
                position += 9;
            }
            return position;
        }
    }

    public static final class HooksCommon {
        private static Field FAKE_PLAYER_MAP = null;

        public static int isInOuterLands(int entityDim, Entity entity) {
            EntityInOuterLandsEvent event = new EntityInOuterLandsEvent(entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            boolean pass = event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT && entity.func_130014_f_().field_73011_w.getDimension() == ModConfig.CONFIG_WORLD.dimensionOuterId;
            return pass ? entityDim : entityDim + 1;
        }

        public static void clearDropChances(EntityLiving entity) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                entity.func_184642_a(slot, 0.0f);
            }
        }

        public static boolean isEntityDeadForProcessInteract(boolean original, EntityLivingBase entity) {
            return original || entity.func_110143_aJ() <= 1.0E-5f;
        }

        public static boolean fireFluxRiftDestroyBlockEvent(EntityFluxRift rift, BlockPos pos, IBlockState state) {
            return MinecraftForge.EVENT_BUS.post((Event)new FluxRiftDestroyBlockEvent(rift, pos, state));
        }

        public static EntityArrow fireArrow(EntityLivingBase shooter, float range) {
            ItemStack arrow = shooter.func_184614_ca();
            EntityArrow entity = null;
            if (arrow.func_77973_b() instanceof ItemArrow && (entity = ((ItemArrow)arrow.func_77973_b()).func_185052_a(shooter.func_130014_f_(), arrow, shooter)).func_70242_d() < 2.25) {
                entity.func_70239_b(2.25 + (double)(range * 2.0f) + shooter.func_70681_au().nextGaussian() * 0.25);
            }
            return entity;
        }

        public static boolean isArrowInfinite(EntityLivingBase shooter) {
            EntityPlayer fakePlayer = null;
            if (shooter instanceof EntityPlayer) {
                fakePlayer = (EntityPlayer)shooter;
            } else if (!shooter.func_130014_f_().field_72995_K) {
                String fakeUsername = "TF";
                if (shooter instanceof IEntityOwnable && ((IEntityOwnable)shooter).func_184753_b() != null) {
                    if ((fakeUsername = fakeUsername + Long.toHexString(((IEntityOwnable)shooter).func_184753_b().getLeastSignificantBits())).length() > 16) {
                        fakeUsername = fakeUsername.substring(0, 16);
                    }
                } else {
                    fakeUsername = fakeUsername + "UnownedCrssbw";
                }
                fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)shooter.func_130014_f_()), (GameProfile)new GameProfile(null, fakeUsername));
                fakePlayer.func_70029_a(shooter.func_130014_f_());
                ((FakePlayer)fakePlayer).field_71134_c.func_73080_a((WorldServer)shooter.func_130014_f_());
            }
            ItemStack arrow = shooter.func_184614_ca();
            return arrow.func_77973_b() instanceof ItemArrow ? Boolean.valueOf(((ItemArrow)arrow.func_77973_b()).isInfinite(arrow, new ItemStack((Item)Items.field_151031_f), fakePlayer)) : null;
        }

        private static void setFakePlayerMapEntry(FakePlayer toInsert) {
            try {
                if (FAKE_PLAYER_MAP == null) {
                    FAKE_PLAYER_MAP = FakePlayerFactory.class.getDeclaredField("fakePlayers");
                    FAKE_PLAYER_MAP.setAccessible(true);
                }
                ((Map)FAKE_PLAYER_MAP.get(null)).put(toInsert.func_146103_bH(), toInsert);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public static FakePlayer makeBoreFakePlayer(FakePlayer original, EntityArcaneBore bore) {
            int destructive;
            float radiusLeft;
            if (!(original instanceof NoEquipSoundFakePlayer)) {
                NoEquipSoundFakePlayer newPlayer = new NoEquipSoundFakePlayer(original.func_71121_q(), original.func_146103_bH());
                HooksCommon.setFakePlayerMapEntry(newPlayer);
                original = newPlayer;
            }
            original.func_70095_a((radiusLeft = (float)bore.getDigRadius() - bore.currentRadius) <= (float)(destructive = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE)));
            return original;
        }

        public static boolean isBoreTargetAir(World world, BlockPos target, boolean original, EntityArcaneBore bore) {
            boolean air = world.func_175623_d(target);
            if (air && world.func_175699_k(target) < 10 && EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.LAMPLIGHT) > 0) {
                world.func_175656_a(target, BlocksTC.effectGlimmer.func_176223_P());
            }
            return air;
        }

        public static int modSpiral(int old, EntityArcaneBore bore) {
            int radMod = Math.max(0, (10 - Math.abs((int)bore.currentRadius)) * 2);
            return old - radMod;
        }

        public static float modCurrentRadius(float old, EntityArcaneBore bore) {
            int spiralStep = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE) * 2;
            return old + (float)spiralStep;
        }

        public static float modCurrentRadiusReset(float zero, EntityArcaneBore bore) {
            int spiralStep = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)bore.func_184614_ca(), (EnumInfusionEnchantment)EnumInfusionEnchantment.DESTRUCTIVE) * 2 + 1;
            return spiralStep > 1 ? (bore.currentRadius - (float)bore.getDigRadius()) % (float)spiralStep : 0.0f;
        }

        public static Vec3d modRotation(Vec3d old, EntityArcaneBore bore) {
            EnumFacing facing = bore.getFacing();
            Vec3d src = new Vec3d((double)MathHelper.func_76128_c((double)bore.field_70165_t) + 0.5 + (double)facing.func_82601_c(), (double)MathHelper.func_76128_c((double)bore.field_70163_u) + 0.5 + (double)facing.func_96559_d(), (double)MathHelper.func_76128_c((double)bore.field_70161_v) + 0.5 + (double)facing.func_82599_e());
            Vec3d vec = new Vec3d(0.0, (double)bore.currentRadius, 0.0);
            vec = Utils.rotateAroundZ((Vec3d)vec, (float)((float)Math.toRadians(bore.spiral)));
            vec = facing.func_176740_k() != EnumFacing.Axis.Y ? Utils.rotateAroundY((Vec3d)vec, (float)((float)Math.toRadians(facing.func_185119_l()))) : Utils.rotateAroundX((Vec3d)vec, (float)(1.5707964f * (float)facing.func_96559_d()));
            Vec3d res = src.func_72441_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            return res;
        }

        public static double getFixedDistanceSq(EntityArcaneBore bore, BlockPos target, double old) {
            return target.func_177957_d((double)MathHelper.func_76128_c((double)bore.field_70165_t) + 0.5, (double)MathHelper.func_76128_c((double)bore.field_70163_u) + 0.5, (double)MathHelper.func_76128_c((double)bore.field_70161_v) + 0.5);
        }
    }
}

