/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.api.FeatureControlApi;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.Types;

public class FeatureTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> GENERATE_AURA = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/world/aura/AuraHandler", false, "generateAura", Type.VOID_TYPE, Types.CHUNK, Types.RANDOM)).findNextMethodCall(new MethodDefinition("thaumcraft/common/world/biomes/BiomeHandler", false, "getBiomeBlacklist", Type.INT_TYPE, Type.INT_TYPE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new MethodDefinition(HOOKS, false, "shouldGenerateAura", Type.INT_TYPE, Type.INT_TYPE, Types.CHUNK).asMethodInsnNode(184)}).build());
    public static final Supplier<ITransformer> GENERATE_CRYSTALS = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/world/ThaumcraftWorldGenerator", false, "generateOres", Type.VOID_TYPE, Types.WORLD, Types.RANDOM, Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE)).findNextFieldAccess(new FieldDefinition("thaumcraft/common/config/ModConfig$CONFIG_WORLD", "generateCrystals", Type.BOOLEAN_TYPE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(21, 3), new VarInsnNode(21, 4), new MethodDefinition(HOOKS, false, "shouldGenerateCrystals", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Types.WORLD, Type.INT_TYPE, Type.INT_TYPE).asMethodInsnNode(184)}).build());
    public static final Supplier<ITransformer> GENERATE_VEGETATION = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/world/ThaumcraftWorldGenerator", false, "generateVegetation", Type.VOID_TYPE, Types.WORLD, Types.RANDOM, Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE)).findNextMethodCall(new MethodDefinition("thaumcraft/common/world/biomes/BiomeHandler", false, "getBiomeBlacklist", Type.INT_TYPE, Type.INT_TYPE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(21, 3), new VarInsnNode(21, 4), new MethodDefinition(HOOKS, false, "shouldGenerateVegetation", Type.INT_TYPE, Type.INT_TYPE, Types.WORLD, Type.INT_TYPE, Type.INT_TYPE).asMethodInsnNode(184)}).build());

    public static final class Hooks {
        public static int shouldGenerateAura(int original, Chunk chunk) {
            if (original >= 0 || !FeatureControlApi.isControllingAuraGen()) {
                return original;
            }
            if (!FeatureControlApi.auraAllowedDimensions().contains(chunk.func_177412_p().field_73011_w.func_186058_p())) {
                return 1;
            }
            if (!FeatureControlApi.auraAllowedBiomes().contains(chunk.func_177412_p().func_180494_b(chunk.func_177412_p().func_175645_m(new BlockPos(chunk.field_76635_g * 16 + 8, 0, chunk.field_76647_h * 16 + 8))))) {
                return 1;
            }
            return -1;
        }

        public static boolean shouldGenerateCrystals(boolean original, World world, int chunkX, int chunkZ) {
            if (!original || !FeatureControlApi.isControllingCrystalGen()) {
                return original;
            }
            if (!FeatureControlApi.crystalAllowedDimensions().contains(world.field_73011_w.func_186058_p())) {
                return false;
            }
            return FeatureControlApi.crystalAllowedBiomes().contains(world.func_180494_b(world.func_175645_m(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8))));
        }

        public static int shouldGenerateVegetation(int original, World world, int chunkX, int chunkZ) {
            if (original >= 0 || !FeatureControlApi.isControllingVegetationGen()) {
                return original;
            }
            if (!FeatureControlApi.vegetationAllowedDimensions().contains(world.field_73011_w.func_186058_p())) {
                return 1;
            }
            if (!FeatureControlApi.vegetationAllowedBiomes().contains(world.func_180494_b(world.func_175645_m(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8))))) {
                return 1;
            }
            return -1;
        }
    }
}

