/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.lib.crafting.ContainerFake;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.common.inventory.FakeArcaneWorkbenchInventory;
import thecodex6824.thaumcraftfix.common.inventory.InventoryCraftingWrapper;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;
import thecodex6824.thaumcraftfix.core.transformer.Types;
import thecodex6824.thaumcraftfix.core.transformer.custom.ChangeVariableTypeTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.ThrowingTransformerWrapper;

public class MiscTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> ARCANE_WORKBENCH_RECIPE_COMPAT = () -> new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/container/ContainerArcaneWorkbench", false, "func_192389_a", Type.VOID_TYPE, Types.WORLD, Types.ENTITY_PLAYER, Types.INVENTORY_CRAFTING, Types.INVENTORY_CRAFT_RESULT))).findConsecutive().findNextLocalAccess(3)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.I_RECIPE.getInternalName(), true, "func_77572_b", Types.ITEM_STACK, Types.INVENTORY_CRAFTING)))).endConsecutive().matchLastNodeOnly().insertInstructionsBefore(new AbstractInsnNode[]{new MethodDefinition(HOOKS, false, "makeVanillaRecipeWrapper", Types.INVENTORY_CRAFTING, Types.INVENTORY_CRAFTING).asMethodInsnNode(184)}).build());
    public static final Supplier<ITransformer> ASPECT_RECIPE_MATCHES = () -> {
        LabelNode afterRet = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/crafting/ThaumcraftCraftingManager", false, "getAspectsFromIngredients", Types.ASPECT_LIST, Types.NON_NULL_LIST, Types.ITEM_STACK, Types.I_RECIPE, Types.ARRAY_LIST)).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.I_RECIPE.getInternalName(), true, "func_179532_b", Types.NON_NULL_LIST, Types.INVENTORY_CRAFTING)))).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(87), new MethodDefinition(HOOKS, false, "createFilledInventoryForRecipe", Types.INVENTORY_CRAFTING, Types.I_RECIPE).asMethodInsnNode(184), new InsnNode(89), new VarInsnNode(58, 7), new JumpInsnNode(199, afterRet), new VarInsnNode(25, 4), new InsnNode(176), afterRet, new FrameNode(3, 0, null, 0, null), new VarInsnNode(25, 2), new VarInsnNode(25, 7)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> ASPECT_REGISTRY_LOOKUP = () -> {
        LabelNode registerLabel = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/api/aspects/AspectEventProxy", false, "registerObjectTag", Type.VOID_TYPE, Types.ITEM_STACK, Types.ASPECT_LIST)).findAny()).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new MethodDefinition(HOOKS, false, "handleEmptyAspectList", Type.BOOLEAN_TYPE, Types.ITEM_STACK, Types.ASPECT_LIST).asMethodInsnNode(184), new JumpInsnNode(154, registerLabel), new InsnNode(177), registerLabel, new FrameNode(3, 0, null, 0, null)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> OBJ_MODEL_NO_SCALA = () -> new ThrowingTransformerWrapper(new ChangeVariableTypeTransformer(new MethodDefinition("thaumcraft/client/lib/obj/MeshLoader", false, "addFace", Type.VOID_TYPE, Types.STRING), Type.getType((String)"Lscala/NotImplementedError;"), Type.getType(UnsupportedOperationException.class), false));

    public static final class Hooks {
        private static final Set<ResourceLocation> BROKEN_RECIPES = new HashSet<ResourceLocation>();

        public static boolean handleEmptyAspectList(ItemStack stack, AspectList list) {
            if (list == null || list.size() == 0) {
                try {
                    if (stack.func_77984_f() || !stack.func_77981_g()) {
                        stack = stack.func_77946_l();
                        stack.func_77964_b(Short.MAX_VALUE);
                    }
                    CommonInternals.objectTags.putIfAbsent(CommonInternals.generateUniqueItemstackId((ItemStack)stack), new AspectList());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }

        public static InventoryCrafting makeVanillaRecipeWrapper(InventoryCrafting input) {
            return new InventoryCraftingWrapper(input);
        }

        @Nullable
        public static InventoryCrafting createFilledInventoryForRecipe(IRecipe recipe) {
            boolean matches;
            FakeArcaneWorkbenchInventory ret;
            block12: {
                if (recipe.func_192399_d() || !recipe.func_194133_a(3, 3)) {
                    return null;
                }
                ret = null;
                ret = recipe instanceof IArcaneRecipe ? new FakeArcaneWorkbenchInventory((Container)new ContainerFake(), 5, 3) : new InventoryCrafting((Container)new ContainerFake(), 3, 3);
                int recipeWidth = -1;
                if (recipe instanceof IShapedRecipe) {
                    recipeWidth = ((IShapedRecipe)recipe).getRecipeWidth();
                }
                int slot = 0;
                boolean bail = false;
                try {
                    for (Ingredient ingredient : recipe.func_192400_c()) {
                        boolean isEmpty;
                        boolean bl = isEmpty = ingredient == Ingredient.field_193370_a;
                        if (!isEmpty && ingredient.func_193365_a().length == 0) {
                            return null;
                        }
                        ItemStack stack = isEmpty ? ItemStack.field_190927_a : ingredient.func_193365_a()[0].func_77946_l();
                        ret.func_70299_a(slot++, stack);
                        if (recipeWidth <= 0 || slot % 3 % recipeWidth != 0) continue;
                        slot += 3 - recipeWidth;
                    }
                }
                catch (Exception ex) {
                    if (BROKEN_RECIPES.add(recipe.getRegistryName())) {
                        ThaumcraftFix.instance.getLogger().error("Failed setting crafting grid slots (recipe might have lied about fitting in a 3x3 grid)", (Throwable)ex);
                        ThaumcraftFix.instance.getLogger().error("Note: future errors with this recipe will not be logged");
                    }
                    bail = true;
                }
                matches = false;
                if (!bail) {
                    IArcaneRecipe arcane;
                    if (recipe instanceof IArcaneRecipe && (arcane = (IArcaneRecipe)recipe).getCrystals() != null) {
                        for (ShardType shard : ShardType.values()) {
                            if (shard.getMetadata() >= 6 || arcane.getCrystals().getAmount(shard.getAspect()) <= 0) continue;
                            ret.func_70299_a(shard.getMetadata() + 9, ThaumcraftApiHelper.makeCrystal((Aspect)shard.getAspect(), (int)arcane.getCrystals().getAmount(shard.getAspect())));
                        }
                    }
                    try {
                        matches = recipe.func_77569_a((InventoryCrafting)ret, null);
                    }
                    catch (Exception ex) {
                        if (!BROKEN_RECIPES.add(recipe.getRegistryName())) break block12;
                        ThaumcraftFix.instance.getLogger().error("Failed calling IRecipe#matches", (Throwable)ex);
                        ThaumcraftFix.instance.getLogger().error("Note: future errors with this recipe will not be logged");
                    }
                }
            }
            return matches ? ret : null;
        }
    }
}

