/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.items.IScribeTools;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thecodex6824.coremodlib.LocalVariableDefinition;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.event.research.ResearchEntryLoadEvent;
import thecodex6824.thaumcraftfix.api.event.research.ResearchLoadEvent;
import thecodex6824.thaumcraftfix.common.network.PacketGainKnowledge;
import thecodex6824.thaumcraftfix.common.network.PacketGainResearch;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.Types;

public class ResearchTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> KNOWLEDGE_GAIN_EVENT_CLIENT = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/research/ResearchManager", false, "addKnowledge", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Type.getType((String)"Lthaumcraft/api/capabilities/IPlayerKnowledge$EnumKnowledgeType;"), Type.getType((String)"Lthaumcraft/api/research/ResearchCategory;"), Type.INT_TYPE)).findNextMethodCall(new MethodDefinition("thaumcraft/api/capabilities/IPlayerKnowledge", true, "addKnowledge", Type.BOOLEAN_TYPE, Type.getType((String)"Lthaumcraft/api/capabilities/IPlayerKnowledge$EnumKnowledgeType;"), Type.getType((String)"Lthaumcraft/api/research/ResearchCategory;"), Type.INT_TYPE))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(25, 1), new VarInsnNode(25, 2), new VarInsnNode(21, 3), new MethodInsnNode(184, HOOKS, "sendKnowledgeGainPacket", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_PLAYER, Type.getType((String)"Lthaumcraft/api/capabilities/IPlayerKnowledge$EnumKnowledgeType;"), Type.getType((String)"Lthaumcraft/api/research/ResearchCategory;"), Type.INT_TYPE}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> RESEARCH_GAIN_EVENT_CLIENT = () -> new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/research/ResearchManager", false, "progressResearch", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.STRING, Type.BOOLEAN_TYPE)).findConsecutive().findNextLocalAccess(2)).findNextInstructionType(JumpInsnNode.class)).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new VarInsnNode(25, 1), new MethodInsnNode(184, HOOKS, "sendResearchGainPacket", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_PLAYER, Types.STRING}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> RESEARCH_PATCHER = () -> {
        LabelNode continueLabel = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.TransformerBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/research/ResearchManager", false, "parseAllResearch", Type.VOID_TYPE, new Type[0])).insertInstructionsBefore(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS, "researchLoadStart", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false)}).findNextMethodCall(new MethodDefinition("java/lang/Class", false, "getResourceAsStream", Types.INPUT_STREAM, Types.STRING))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 2), new MethodInsnNode(184, HOOKS, "getFilesystemStream", Type.getMethodDescriptor((Type)Types.INPUT_STREAM, (Type[])new Type[]{Types.INPUT_STREAM, Types.RESOURCE_LOCATION}), false)}).findConsecutive().findNextInstructionType(FrameNode.class)).findNextLocalAccess(9)).findNextMethodCall(new MethodDefinition(Types.ITERATOR.getInternalName(), true, "hasNext", Type.BOOLEAN_TYPE, new Type[0]))).endConsecutive().findNextMethodCall(new MethodDefinition(Types.JSON_ELEMENT.getInternalName(), false, "getAsJsonObject", Types.JSON_OBJECT, new Type[0]))).combineLastTwoMatches().insertInstructionsSurrounding().before(new AbstractInsnNode[]{continueLabel}).after(new AbstractInsnNode[]{new IincInsnNode(8, -1), new InsnNode(89), new VarInsnNode(58, 11), new MethodInsnNode(184, HOOKS, "entryLoadStart", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.JSON_OBJECT}), false), new JumpInsnNode(153, continueLabel), new IincInsnNode(8, 1), new VarInsnNode(25, 11)}).endAction().findNextMethodCall(new MethodDefinition("thaumcraft/common/lib/research/ResearchManager", false, "addResearchToCategory", Type.VOID_TYPE, Types.RESEARCH_ENTRY))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 11), new VarInsnNode(25, 12), new MethodInsnNode(184, HOOKS, "entryLoadEnd", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.JSON_OBJECT, Types.RESEARCH_ENTRY}), false)}).findNextOpcode(177)).insertInstructionsBefore(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS, "researchLoadEnd", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> PARSE_PAGE_FIRST_PASS = () -> {
        Type stringArray = Type.getType((String)"[Ljava/lang/String;");
        MethodDefinition split = new MethodDefinition(Types.STRING.getInternalName(), false, "split", stringArray, Types.STRING);
        MethodDefinition fixup = new MethodDefinition(HOOKS, false, "fixupFirstPassSplit", stringArray, Types.STRING, Types.STRING, stringArray);
        return new GenericStateMachineTransformer(((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/client/gui/GuiResearchPage", false, "parsePages", Type.VOID_TYPE, new Type[0])).findConsecutive().findNextLocalAccess(new LocalVariableDefinition("rawText", Types.STRING))).findNextStringConstant("<IMG>")).findNextMethodCall(split)).endConsecutive().findConsecutive().findNextLocalAccess(new LocalVariableDefinition("rawText", Types.STRING))).findNextStringConstant("~P")).findNextMethodCall(split)).endConsecutive().matchLastNodeOnly().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{fixup.asMethodInsnNode(184)}).endAction().findConsecutive().findNextLocalAccess(new LocalVariableDefinition("t", Types.STRING))).findNextStringConstant("~D")).findNextMethodCall(split)).endConsecutive().matchLastNodeOnly().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{fixup.asMethodInsnNode(184)}).endAction().findConsecutive().findNextLocalAccess(new LocalVariableDefinition("t1", Types.STRING))).findNextStringConstant("~L")).findNextMethodCall(split)).endConsecutive().matchLastNodeOnly().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{fixup.asMethodInsnNode(184)}).endAction().findConsecutive().findNextLocalAccess(new LocalVariableDefinition("t2", Types.STRING))).findNextStringConstant("~I")).findNextMethodCall(split)).endConsecutive().matchLastNodeOnly().insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(92)}).after(new AbstractInsnNode[]{fixup.asMethodInsnNode(184)}).endAction().build(), true, 1);
    };
    public static final Supplier<ITransformer> SCAN_SKY_SCRIBE_CHECK = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/research/ScanSky", false, "onSuccess", Type.VOID_TYPE, Types.ENTITY_PLAYER, Types.OBJECT)).findNextMethodCall(new MethodDefinition("thaumcraft/common/lib/utils/InventoryUtils", false, "isPlayerCarryingAmount", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.ITEM_STACK, Type.BOOLEAN_TYPE))).insertInstructionsSurrounding().before(new AbstractInsnNode[]{new InsnNode(93)}).after(new AbstractInsnNode[]{new VarInsnNode(25, 1), new MethodInsnNode(184, HOOKS, "isPlayerCarryingScribingTools", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Types.ITEM_STACK, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER}), false)}).endAction().build());

    public static final class Hooks {
        public static void sendKnowledgeGainPacket(EntityPlayer player, IPlayerKnowledge.EnumKnowledgeType type, ResearchCategory category, int amount) {
            if (player instanceof EntityPlayerMP) {
                ThaumcraftFix.instance.getNetworkHandler().sendTo((IMessage)new PacketGainKnowledge(type, category, amount), (EntityPlayerMP)player);
            }
        }

        public static void sendResearchGainPacket(EntityPlayer player, String researchKey) {
            if (player instanceof EntityPlayerMP) {
                ThaumcraftFix.instance.getNetworkHandler().sendTo((IMessage)new PacketGainResearch(researchKey), (EntityPlayerMP)player);
            }
        }

        public static String[] fixupFirstPassSplit(String rawText, String separator, String[] split) {
            if (rawText.endsWith(separator)) {
                split = Arrays.copyOf(split, split.length + 1);
                split[split.length - 1] = "";
            }
            return split;
        }

        public static void researchLoadStart() {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchLoadEvent.Pre());
        }

        public static void researchLoadEnd() {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchLoadEvent.Post());
        }

        public static boolean entryLoadStart(JsonObject json) {
            ResearchEntryLoadEvent.Pre event = new ResearchEntryLoadEvent.Pre(json);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }

        public static void entryLoadEnd(JsonObject json, ResearchEntry entry) {
            MinecraftForge.EVENT_BUS.post((Event)new ResearchEntryLoadEvent.Post(json, entry));
        }

        public static InputStream getFilesystemStream(InputStream stream, ResourceLocation loc) {
            String prefix = "$filesystem:";
            if (stream == null && loc.func_110624_b().equals("thaumcraftfix") && loc.func_110623_a().startsWith(prefix)) {
                Path gameDir = ThaumcraftFix.proxy.getGameDirectory().toPath().normalize();
                Path requested = Paths.get(loc.func_110623_a().substring(prefix.length()), new String[0]);
                if (!requested.isAbsolute() && requested.getRoot() == null) {
                    try {
                        stream = new FileInputStream(gameDir.resolve(requested.normalize()).toFile());
                    }
                    catch (IOException ex) {
                        ThaumcraftFix.instance.getLogger().error("Failed opening research file: ", (Throwable)ex);
                    }
                } else {
                    ThaumcraftFix.instance.getLogger().error("Illegal research entry path, paths must be relative to the game directory: " + requested);
                }
            }
            return stream;
        }

        public static boolean isPlayerCarryingScribingTools(ItemStack isCarrying, boolean ore, boolean original, EntityPlayer player) {
            if (original || isCarrying.func_77973_b() != ItemsTC.scribingTools) {
                return original;
            }
            for (ItemStack stack : Iterables.concat((Iterable)player.field_71071_by.field_184439_c, (Iterable)player.field_71071_by.field_70462_a)) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IScribeTools)) continue;
                return true;
            }
            return false;
        }
    }
}

