/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.api.research.ResearchCategoryTheorycraftFilter;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.Types;

public class TheorycraftTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> CARD_ANALYZE_CATEGORIES = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/api/research/theorycraft/CardAnalyze", false, "initialize", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA)).findNextMethodCall(new MethodDefinition(Types.ARRAY_LIST.getInternalName(), false, "size", Type.INT_TYPE, new Type[0]))).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new MethodInsnNode(184, HOOKS, "filterTheorycraftCategories", Type.getMethodDescriptor((Type)Types.ARRAY_LIST, (Type[])new Type[]{Types.ARRAY_LIST, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> CARD_CURIO_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardCurio");
    public static final Supplier<ITransformer> CARD_DARK_WHISPERS_CATEGORIES = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/research/theorycraft/CardDarkWhispers", false, "activate", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA)).findNextMethodCall(new MethodDefinition(Types.RANDOM.getInternalName(), false, "nextBoolean", Type.BOOLEAN_TYPE, new Type[0]))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 5), new VarInsnNode(25, 1), new VarInsnNode(25, 2), new MethodInsnNode(184, HOOKS, "isTheorycraftCategoryAllowed", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Types.STRING, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> CARD_DRAGON_EGG_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardDragonEgg");
    public static final Supplier<ITransformer> CARD_EXPERIMENTATION_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/api/research/theorycraft/CardExperimentation");
    public static final Supplier<ITransformer> CARD_GLYPHS_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardGlyphs");
    public static final Supplier<ITransformer> CARD_PORTAL_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardPortal");
    public static final Supplier<ITransformer> CARD_REALIZATION_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardRealization");
    public static final Supplier<ITransformer> CARD_REVELATION_CATEGORIES = TheorycraftTransformers.makeStringArrayFilterTransformer("thaumcraft/common/lib/research/theorycraft/CardRevelation");
    public static final Supplier<ITransformer> RESEARCH_TABLE_DATA_CATEGORIES = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(Types.RESEARCH_TABLE_DATA.getInternalName(), false, "getAvailableCategories", Types.ARRAY_LIST, Types.ENTITY_PLAYER)).findNextOpcode(176)).insertInstructionsBefore(new AbstractInsnNode[]{new MethodInsnNode(184, HOOKS, "filterTheorycraftCategories", Type.getMethodDescriptor((Type)Types.ARRAY_LIST, (Type[])new Type[]{Types.ARRAY_LIST}), false)}).build());

    private static Supplier<ITransformer> makeStringArrayFilterTransformer(String internalName) {
        return () -> {
            Type strArray = Type.getType((String)"[Ljava/lang/String;");
            return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition(internalName, false, "activate", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA)).findNextLocalAccess(3)).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 1), new VarInsnNode(25, 2), new MethodInsnNode(184, HOOKS, "filterTheorycraftCategoriesArray", Type.getMethodDescriptor((Type)strArray, (Type[])new Type[]{strArray, Types.ENTITY_PLAYER, Types.RESEARCH_TABLE_DATA}), false)}).build(), true, 1);
        };
    }

    public static final class Hooks {
        public static boolean isTheorycraftCategoryAllowed(boolean originalDecision, String category, EntityPlayer player, ResearchTableData data) {
            return originalDecision && data.getAvailableCategories(player).contains(category) && ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).anyMatch(s -> s.equals(category));
        }

        public static ArrayList<String> filterTheorycraftCategories(ArrayList<String> input) {
            input.retainAll(ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).collect(Collectors.toList()));
            return input;
        }

        public static ArrayList<String> filterTheorycraftCategories(ArrayList<String> input, EntityPlayer player, ResearchTableData data) {
            input.retainAll(data.getAvailableCategories(player));
            input.retainAll(ResearchCategoryTheorycraftFilter.getAllowedTheorycraftCategories().stream().map(c -> c.key).collect(Collectors.toList()));
            return input;
        }

        public static String[] filterTheorycraftCategoriesArray(String[] input, EntityPlayer player, ResearchTableData data) {
            ArrayList<String> list = Lists.newArrayList((Object[])input);
            list = Hooks.filterTheorycraftCategories(list, player, data);
            return list.toArray(new String[0]);
        }
    }
}

