/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.event;

import com.google.common.base.Predicate;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.world.aura.AuraThread;
import thecodex6824.thaumcraftfix.api.aura.CapabilityAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.common.aura.GenericAuraThread;

@Mixin(value={ServerEvents.class})
public class ServerEventsMixin {
    private static ThreadLocal<Field> sourceField = new ThreadLocal();
    private static ThreadLocal<Field> targetField = new ThreadLocal();

    @Redirect(method={"worldTick(Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;)V"}, at=@At(value="NEW", target="(I)Lthaumcraft/common/world/aura/AuraThread;", remap=false), remap=false)
    private static AuraThread redirectCreateAuraThread(int dim, TickEvent.WorldTickEvent event) {
        return new GenericAuraThread(dim, (IAuraProcessor)event.world.getCapability(CapabilityAuraProcessor.AURA_PROCESSOR, null));
    }

    private static Object getSwapperSource(ServerEvents.VirtualSwapper vs) {
        try {
            if (sourceField.get() == null) {
                Field field = ServerEvents.VirtualSwapper.class.getDeclaredField("source");
                field.setAccessible(true);
                sourceField.set(field);
            }
            return sourceField.get().get(vs);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static ItemStack getSwapperTarget(ServerEvents.VirtualSwapper vs) {
        try {
            if (targetField.get() == null) {
                Field field = ServerEvents.VirtualSwapper.class.getDeclaredField("target");
                field.setAccessible(true);
                targetField.set(field);
            }
            return (ItemStack)targetField.get().get(vs);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="NEW", target="(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraftforge/common/util/BlockSnapshot;", remap=false)}, remap=false)
    private static BlockSnapshot wrapCreateSnapshot(World world, BlockPos pos, IBlockState oldStateIgnore, Operation<BlockSnapshot> originalThatIsWrong, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef, @Local(ordinal=0) ServerEvents.VirtualSwapper vs) {
        Block block;
        IBlockState toPlace = null;
        ItemStack target = ServerEventsMixin.getSwapperTarget(vs);
        if (target != null && !target.func_190926_b() && (block = Block.func_149634_a((Item)target.func_77973_b())) != null && block != Blocks.field_150350_a) {
            toPlace = block.func_176203_a(target.func_77952_i());
        }
        BlockSnapshot newSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        snapshotRef.set((Object)newSnapshot);
        if (toPlace != null) {
            world.func_175656_a(pos, toPlace);
        } else {
            world.func_175698_g(pos);
        }
        return newSnapshot;
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onPlayerBlockPlace(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraftforge/common/util/BlockSnapshot;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/util/EnumHand;)Lnet/minecraftforge/event/world/BlockEvent$PlaceEvent;", remap=false)}, remap=false)
    private static BlockEvent.PlaceEvent wrapPlaceEvent(@Nonnull EntityPlayer player, @Nonnull BlockSnapshot snapshot, @Nonnull EnumFacing direction, @Nonnull EnumHand hand, Operation<BlockEvent.PlaceEvent> original) {
        BlockEvent.PlaceEvent result = (BlockEvent.PlaceEvent)original.call(new Object[]{player, snapshot, direction, hand});
        if (result.isCanceled()) {
            snapshot.restore(true, false);
        }
        return result;
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Predicate;apply(Ljava/lang/Object;)Z", remap=false, ordinal=0)}, remap=false)
    private static boolean wrapSwapperPredicateCheck(Predicate<Boolean> predicate, @Nullable Object input, Operation<Boolean> original, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        boolean result = (Boolean)original.call(new Object[]{predicate, input});
        if (!result) {
            ((BlockSnapshot)snapshotRef.get()).restore(true, false);
        }
        return result;
    }

    @Inject(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="FIELD", target="Lthaumcraft/common/lib/events/ServerEvents$VirtualSwapper;source:Ljava/lang/Object;", ordinal=10, opcode=180)}, remap=false)
    private static void handleRestoreIfNeeded(World world, CallbackInfo info, @Local(ordinal=0) ServerEvents.VirtualSwapper vs, @Local(ordinal=1) boolean matches, @Local(ordinal=1) int slot, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        if (ServerEventsMixin.getSwapperSource(vs) != null && !matches || slot < 0) {
            ((BlockSnapshot)snapshotRef.get()).restore(true, false);
        }
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", remap=true)}, remap=false)
    private static boolean wrapOriginalSetBlockstate(World world, BlockPos pos, IBlockState state, int flags, Operation<Boolean> original, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        boolean result = true;
        if (snapshotRef.get() == null) {
            result = (Boolean)original.call(new Object[]{world, pos, state, flags});
        }
        return result;
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z", remap=true)}, remap=false)
    private static boolean wrapOriginalSetBlockToAir(World world, BlockPos pos, Operation<Boolean> original, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        boolean result = true;
        if (snapshotRef.get() == null) {
            result = (Boolean)original.call(new Object[]{world, pos});
        }
        return result;
    }
}

