/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import thaumcraft.common.items.tools.ItemElementalShovel;
import thaumcraft.common.lib.utils.InventoryUtils;

@Mixin(value={ItemElementalShovel.class})
public class ItemElementalShovelMixin {
    @ModifyExpressionValue(method={"onItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", ordinal=0)})
    private IBlockState saveClickedBlock(IBlockState state, @Share(value="clickedState") LocalRef<IBlockState> clickedState) {
        clickedState.set((Object)state);
        return state;
    }

    @ModifyExpressionValue(method={"onItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;canPlaceBlockAt(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", ordinal=0)})
    private boolean saveItemWeAreTaking(boolean original, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, @Share(value="clickedState") LocalRef<IBlockState> clickedState, @Share(value="goodItem") LocalRef<ItemStack> goodItem) {
        IBlockState wantedState = (IBlockState)clickedState.get();
        Vec3d fakeHit = new Vec3d((double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() / 2.0, (double)pos.func_177956_o() + 0.5 + (double)side.func_96559_d() / 2.0, (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() / 2.0);
        ItemStack picked = wantedState.func_177230_c().getPickBlock(wantedState, new RayTraceResult(fakeHit, side, pos), world, pos, player);
        goodItem.set((Object)picked);
        return original;
    }

    @Redirect(method={"onItemUse"}, at=@At(value="INVOKE", target="Lthaumcraft/common/lib/utils/InventoryUtils;consumePlayerItem(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/Item;I)Z", ordinal=0, remap=false))
    private boolean redirectConsumePlayerItemForBlockPlacement(EntityPlayer player, Item wrongItem, int wrongMeta, @Share(value="goodItem") LocalRef<ItemStack> goodItem) {
        ItemStack stack = (ItemStack)goodItem.get();
        return stack != null && !stack.func_190926_b() ? InventoryUtils.consumePlayerItem((EntityPlayer)player, (ItemStack)stack, (boolean)false, (boolean)false) : false;
    }

    @WrapOperation(method={"onItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", ordinal=0)})
    private boolean wrapSetBlockStateForBlockPlacement(World world, BlockPos pos, IBlockState state, Operation<Boolean> op, EntityPlayer player, World worldAgain, BlockPos origPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, @Share(value="goodItem") LocalRef<ItemStack> goodItem, @Share(value="didSomething") LocalBooleanRef didSomething) {
        boolean result = false;
        ItemStack item = (ItemStack)goodItem.get();
        float modHitX = hitX + (float)(pos.func_177958_n() - origPos.func_177958_n());
        float modHitY = hitY + (float)(pos.func_177956_o() - origPos.func_177956_o());
        float modHitZ = hitZ + (float)(pos.func_177952_p() - origPos.func_177952_p());
        IBlockState toPlace = state.func_177230_c().getStateForPlacement(world, pos, side, modHitX, modHitY, modHitZ, item.func_77960_j(), (EntityLivingBase)player, hand);
        IBlockState existing = world.func_180495_p(pos);
        if (existing.func_177230_c().func_176200_f((IBlockAccess)world, pos) && player.func_175151_a(pos, side, item) && world.func_190527_a(state.func_177230_c(), pos, false, side, (Entity)player)) {
            if (item.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)item.func_77973_b();
                result = itemBlock.placeBlockAt(item, player, world, pos, side, modHitX, modHitY, modHitZ, toPlace);
            } else {
                result = (Boolean)op.call(new Object[]{toPlace, pos});
            }
        }
        if (result) {
            didSomething.set(true);
        }
        return result;
    }

    @ModifyReturnValue(method={"onItemUse"}, at={@At(value="RETURN")})
    private EnumActionResult changeActionResult(EnumActionResult original, @Share(value="didSomething") LocalBooleanRef didSomething) {
        return didSomething.get() ? EnumActionResult.SUCCESS : original;
    }
}

