/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.core.CapabilitiesHelper;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjEffectManager;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class MjAPI {
    public static final long ONE_MINECRAFT_JOULE;
    public static final long MJ;
    public static int rfPerMj;
    public static final DecimalFormat MJ_DISPLAY_FORMAT;
    public static IMjEffectManager EFFECT_MANAGER;
    @Nonnull
    public static final Capability<IMjConnector> CAP_CONNECTOR;
    @Nonnull
    public static final Capability<IMjReceiver> CAP_RECEIVER;
    @Nonnull
    public static final Capability<IMjRedstoneReceiver> CAP_REDSTONE_RECEIVER;
    @Nonnull
    public static final Capability<IMjReadable> CAP_READABLE;
    @Nonnull
    public static final Capability<IMjPassiveProvider> CAP_PASSIVE_PROVIDER;

    public static String formatMj(long microMj) {
        return MjAPI.formatMjInternal((double)microMj / (double)MJ);
    }

    public static String formatRF(int rf) {
        return MjAPI.formatMjInternal(rf);
    }

    public static String formatRFFromMj(long microMj) {
        return MjAPI.formatRF((int)(microMj * (long)rfPerMj / MJ));
    }

    private static String formatMjInternal(double val) {
        return MJ_DISPLAY_FORMAT.format(val);
    }

    private static long getMjValue() {
        return 1000000L;
    }

    static {
        MJ = ONE_MINECRAFT_JOULE = MjAPI.getMjValue();
        rfPerMj = 10;
        MJ_DISPLAY_FORMAT = new DecimalFormat("#,##0.##");
        EFFECT_MANAGER = NullaryEffectManager.INSTANCE;
        CAP_CONNECTOR = CapabilitiesHelper.registerCapability(IMjConnector.class);
        CAP_RECEIVER = CapabilitiesHelper.registerCapability(IMjReceiver.class);
        CAP_REDSTONE_RECEIVER = CapabilitiesHelper.registerCapability(IMjRedstoneReceiver.class);
        CAP_READABLE = CapabilitiesHelper.registerCapability(IMjReadable.class);
        CAP_PASSIVE_PROVIDER = CapabilitiesHelper.registerCapability(IMjPassiveProvider.class);
    }

    public static enum NullaryEffectManager implements IMjEffectManager
    {
        INSTANCE;


        @Override
        public void createPowerLossEffect(World world, Vec3d center, long microJoulesLost) {
        }

        @Override
        public void createPowerLossEffect(World world, Vec3d center, EnumFacing direction, long microJoulesLost) {
        }

        @Override
        public void createPowerLossEffect(World world, Vec3d center, Vec3d direction, long microJoulesLost) {
        }
    }
}

