/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeFaceTex;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PipeBehaviour
implements ICapabilityProvider {
    public final IPipe pipe;

    public PipeBehaviour(IPipe pipe) {
        this.pipe = pipe;
    }

    public PipeBehaviour(IPipe pipe, NBTTagCompound nbt) {
        this.pipe = pipe;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        return nbt;
    }

    public void writePayload(PacketBuffer buffer, Side side) {
    }

    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
    }

    @Deprecated
    public int getTextureIndex(EnumFacing face) {
        return 0;
    }

    public PipeFaceTex getTextureData(EnumFacing face) {
        return PipeFaceTex.get(this.getTextureIndex(face));
    }

    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return true;
    }

    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        return true;
    }

    public boolean shouldForceConnection(EnumFacing face, TileEntity oTile) {
        return false;
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        return false;
    }

    public void onEntityCollide(Entity entity) {
    }

    public void onTick() {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return null;
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
    }

    public IEnergyStorage getRF() {
        return null;
    }
}

