/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.builders.BCBuildersBlocks;
import buildcraft.builders.BCBuildersConfig;
import buildcraft.builders.BCBuildersEventDist;
import buildcraft.builders.client.render.AdvDebuggerQuarry;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.marker.VolumeCache;
import buildcraft.core.marker.VolumeConnection;
import buildcraft.core.marker.VolumeSubCache;
import buildcraft.core.tile.TileMarkerVolume;
import buildcraft.energy.BCRfWrapper;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.chunkload.ChunkLoaderManager;
import buildcraft.lib.chunkload.IChunkLoadingTile;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.inventory.AutomaticProvidingTransactor;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AxisOrder;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.BoxIterator;
import buildcraft.lib.misc.data.EnumAxisOrder;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.world.WorldEventListenerAdapter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileQuarry
extends TileBC_Neptune
implements ITickable,
IDebuggable,
IChunkLoadingTile {
    public static final boolean DEBUG_QUARRY = BCDebugging.shouldDebugLog("builders.quarry");
    private static final long MAX_POWER_PER_TICK = 512L * MjAPI.MJ;
    private static final ResourceLocation ADVANCEMENT_COMPLETE = new ResourceLocation("buildcraftbuilders:diggy_diggy_hole");
    private final MjBattery battery = new MjBattery(24000L * MjAPI.MJ);
    private final BCRfWrapper wrapper = new BCRfWrapper(this.battery, 512);
    public final Box frameBox = new Box();
    private final Box miningBox = new Box();
    private BoxIterator boxIterator;
    public final List<BlockPos> framePoses = new ArrayList<BlockPos>();
    private int frameBoxPosesCount = 0;
    private final LinkedList<BlockPos> toCheck = new LinkedList();
    private final Set<BlockPos> firstCheckedPoses = new HashSet<BlockPos>();
    private boolean firstChecked = false;
    private final Set<BlockPos> frameBreakBlockPoses = new TreeSet<BlockPos>(BlockUtil.uniqueBlockPosComparator(Comparator.comparingDouble(p -> this.func_174877_v().func_177951_i((Vec3i)p))));
    private final Set<BlockPos> framePlaceFramePoses = new HashSet<BlockPos>();
    public Task currentTask = null;
    public Vec3d drillPos;
    public Vec3d clientDrillPos;
    public Vec3d prevClientDrillPos;
    private long debugPowerRate = 0L;
    private double blockPercentSoFar;
    private double moveDistanceSoFar;
    private List<AxisAlignedBB> collisionBoxes = ImmutableList.of();
    private Vec3d collisionDrillPos;
    private final IWorldEventListener worldEventListener = new WorldEventListenerAdapter(){

        @Override
        public void func_184376_a(World w, BlockPos updatePos, IBlockState oldState, IBlockState newState, int flags) {
            w.field_72984_F.func_76320_a("bc_quarry_listener");
            if (TileQuarry.this.frameBox.isInitialized() && TileQuarry.this.miningBox.isInitialized()) {
                if (TileQuarry.this.frameBox.contains(updatePos)) {
                    TileQuarry.this.check(updatePos);
                } else if (TileQuarry.this.miningBox.contains(updatePos) && TileQuarry.this.boxIterator != null && TileQuarry.this.boxIterator.hasVisited(updatePos) && !TileQuarry.this.canMoveThrough(updatePos) && TileQuarry.this.canMoveDownTo(updatePos)) {
                    TileQuarry.this.boxIterator.moveTo(updatePos);
                }
            }
            w.field_72984_F.func_76319_b();
        }
    };

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.wrapper);
        }
        return super.getCapability(capability, facing);
    }

    public TileQuarry() {
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.battery)));
        this.caps.addCapabilityInstance(CapUtil.CAP_ITEM_TRANSACTOR, AutomaticProvidingTransactor.INSTANCE, EnumPipePart.VALUES);
    }

    @Nonnull
    private BoxIterator createBoxIterator() {
        long z;
        long y;
        long x = this.func_174877_v().func_177958_n();
        long seed = (x & 0xFFFFL) << 0 | ((y = (long)this.func_174877_v().func_177956_o()) & 0xFFFFL) << 16 | (z = (long)this.func_174877_v().func_177952_p()) & 0xFFFFL;
        Random rand = new Random(seed);
        EnumAxisOrder axisOrder = rand.nextBoolean() ? EnumAxisOrder.XZY : EnumAxisOrder.ZXY;
        AxisOrder.Inversion inv = AxisOrder.Inversion.getFor(rand.nextBoolean(), rand.nextBoolean(), false);
        return new BoxIterator(this.miningBox, AxisOrder.getFor(axisOrder, inv), true);
    }

    private List<BlockPos> getFramePositions() {
        HashSet<BlockPos> visitedSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> framePositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openSet = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nextOpenSet = new ArrayList<BlockPos>();
        openSet.add(this.func_174877_v());
        EnumFacing[] order = EnumFacing.values();
        List<EnumFacing> orderAsList = Arrays.asList(order);
        int maxIterationCount = this.frameBox.getBlocksOnEdgeCount();
        int iterationCount = 0;
        do {
            String msg;
            for (BlockPos p : openSet) {
                Collections.shuffle(orderAsList);
                for (EnumFacing face : order) {
                    BlockPos next = p.func_177972_a(face);
                    if (!this.frameBox.isOnEdge(next) || !visitedSet.add(next)) continue;
                    nextOpenSet.add(next);
                    framePositions.add(next);
                }
            }
            openSet.clear();
            ArrayList<BlockPos> t = openSet;
            openSet = nextOpenSet;
            nextOpenSet = t;
            Collections.shuffle(openSet);
            if (openSet.size() > 24) {
                msg = "OpenSet got too big!";
                msg = msg + "\n  Position = " + this.field_174879_c;
                msg = msg + "\n  Frame Box = " + this.frameBox;
                msg = msg + "\n  Iteration Count = " + iterationCount;
                msg = msg + "\n  OpenSet = " + openSet.stream().map(Object::toString).collect(Collectors.joining("\n  ", "[", "]"));
                throw new IllegalStateException(msg);
            }
            if (++iterationCount < maxIterationCount) continue;
            msg = "Failed to generate a correct list of frame positions! Was the frame box wrong?";
            msg = msg + "\n  Position = " + this.field_174879_c;
            msg = msg + "\n  Frame Box = " + this.frameBox;
            msg = msg + "\n  Iteration Count = " + iterationCount;
            msg = msg + "\n  OpenSet = " + openSet.stream().map(Object::toString).collect(Collectors.joining("\n  ", "[", "]"));
            throw new IllegalStateException(msg);
        } while (!openSet.isEmpty());
        if (framePositions.isEmpty()) {
            String msg = "Failed to generate a correct list of frame positions! Was the frame box wrong?";
            msg = msg + "\n  Position = " + this.field_174879_c;
            msg = msg + "\n  Frame Box = " + this.frameBox;
            throw new IllegalStateException(msg);
        }
        return framePositions;
    }

    private boolean shouldBeFrame(BlockPos p) {
        return this.frameBox.isOnEdge(p);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        if (placer.field_70170_p.field_72995_K) {
            return;
        }
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        BlockPos areaPos = this.field_174879_c.func_177972_a(facing.func_176734_d());
        TileEntity tile = this.field_145850_b.func_175625_s(areaPos);
        BlockPos min = null;
        BlockPos max = null;
        if (tile instanceof IAreaProvider) {
            IAreaProvider provider = (IAreaProvider)tile;
            min = provider.min();
            max = provider.max();
            int dx = max.func_177958_n() - min.func_177958_n();
            int dz = max.func_177952_p() - min.func_177952_p();
            if (dx < 3 || dz < 3) {
                min = null;
                max = null;
            } else {
                provider.removeFromWorld();
            }
        }
        if (min == null || max == null) {
            min = null;
            max = null;
            VolumeSubCache cache = (VolumeSubCache)VolumeCache.INSTANCE.getSubCache(this.func_145831_w());
            for (BlockPos markerPos : cache.getAllMarkers()) {
                VolumeConnection connection;
                TileMarkerVolume marker = (TileMarkerVolume)cache.getMarker(markerPos);
                if (marker == null || (connection = (VolumeConnection)marker.getCurrentConnection()) == null) continue;
                Box volBox = connection.getBox();
                Box box2 = new Box();
                box2.initialize(volBox);
                if (!box2.isInitialized() || this.field_174879_c.func_177956_o() != box2.min().func_177956_o() || box2.contains(this.field_174879_c) || !box2.contains(areaPos) || box2.size().func_177958_n() < 3 || box2.size().func_177952_p() < 3) continue;
                box2.expand(1);
                box2.setMin(box2.min().func_177984_a());
                if (!box2.isOnEdge(this.field_174879_c)) continue;
                min = volBox.min();
                max = volBox.max();
                marker.removeFromWorld();
                break;
            }
        }
        if (min == null || max == null) {
            this.miningBox.reset();
            this.frameBox.reset();
            switch (facing.func_176734_d()) {
                default: {
                    min = this.field_174879_c.func_177982_a(1, 0, -5);
                    max = this.field_174879_c.func_177982_a(11, 4, 5);
                    break;
                }
                case WEST: {
                    min = this.field_174879_c.func_177982_a(-11, 0, -5);
                    max = this.field_174879_c.func_177982_a(-1, 4, 5);
                    break;
                }
                case SOUTH: {
                    min = this.field_174879_c.func_177982_a(-5, 0, 1);
                    max = this.field_174879_c.func_177982_a(5, 4, 11);
                    break;
                }
                case NORTH: {
                    min = this.field_174879_c.func_177982_a(-5, 0, -11);
                    max = this.field_174879_c.func_177982_a(5, 4, -1);
                }
            }
        }
        if (max.func_177956_o() - min.func_177956_o() < BCBuildersConfig.quarryFrameMinHeight) {
            max = new BlockPos(max.func_177958_n(), min.func_177956_o() + BCBuildersConfig.quarryFrameMinHeight, max.func_177952_p());
        }
        if (this.field_145850_b.func_189509_E(max)) {
            int dist = max.func_177956_o() - min.func_177956_o();
            min = min.func_177979_c(dist);
            max = max.func_177979_c(dist);
        }
        this.frameBox.reset();
        this.frameBox.setMin(min);
        this.frameBox.setMax(max);
        this.miningBox.reset();
        int minY = max.func_177956_o() - 1 - BCCoreConfig.miningMaxDepth;
        if (this.field_145850_b.func_189509_E(new BlockPos(min.func_177958_n(), minY, min.func_177952_p()))) {
            minY = 0;
        }
        this.miningBox.setMin(new BlockPos(min.func_177958_n() + 1, minY, min.func_177952_p() + 1));
        this.miningBox.setMax(new BlockPos(max.func_177958_n() - 1, max.func_177956_o() - 1, max.func_177952_p() - 1));
        this.updatePoses();
    }

    private boolean canMine(BlockPos blockPos) {
        if (this.field_145850_b.func_180495_p(blockPos).func_185887_b(this.field_145850_b, blockPos) < 0.0f) {
            return false;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos);
        return fluid == null || fluid.getViscosity() <= 1000;
    }

    private boolean canMoveThrough(BlockPos blockPos) {
        if (this.field_145850_b.func_175623_d(blockPos)) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos);
        return fluid != null && fluid.getViscosity() <= 1000;
    }

    private boolean canMoveDownTo(BlockPos blockPos) {
        for (int y = this.miningBox.max().func_177956_o(); y > blockPos.func_177956_o(); --y) {
            if (this.canMoveThrough(VecUtil.replaceValue((Vec3i)blockPos, EnumFacing.Axis.Y, y))) continue;
            return false;
        }
        return true;
    }

    private boolean canIgnoreInFrameBox(BlockPos blockPos) {
        return !this.field_145850_b.func_175623_d(blockPos) && BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos) == null;
    }

    private void check(BlockPos blockPos) {
        this.frameBreakBlockPoses.remove(blockPos);
        this.framePlaceFramePoses.remove(blockPos);
        if (this.shouldBeFrame(blockPos)) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != BCBuildersBlocks.frame) {
                if (this.canIgnoreInFrameBox(blockPos)) {
                    this.frameBreakBlockPoses.add(blockPos);
                } else {
                    this.framePlaceFramePoses.add(blockPos);
                }
            }
        } else if (this.canIgnoreInFrameBox(blockPos)) {
            this.frameBreakBlockPoses.add(blockPos);
        }
        if (!this.firstChecked) {
            this.firstCheckedPoses.add(blockPos);
            if (this.firstCheckedPoses.size() >= this.frameBoxPosesCount) {
                this.firstChecked = true;
            }
        }
    }

    @Override
    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.updatePoses();
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        BCBuildersEventDist.INSTANCE.validateQuarry(this);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72954_a(this.worldEventListener);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        BCBuildersEventDist.INSTANCE.invalidateQuarry(this);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72848_b(this.worldEventListener);
            ChunkLoaderManager.releaseChunksFor(this);
        }
    }

    @Override
    @Nullable
    public IChunkLoadingTile.LoadType getLoadType() {
        return IChunkLoadingTile.LoadType.HARD;
    }

    @Override
    @Nullable
    public Set<ChunkPos> getChunksToLoad() {
        if (!this.miningBox.isInitialized()) {
            return null;
        }
        HashSet<ChunkPos> chunkPoses = new HashSet<ChunkPos>();
        ChunkPos minChunkPos = new ChunkPos(this.frameBox.min());
        ChunkPos maxChunkPos = new ChunkPos(this.frameBox.max());
        for (int x = minChunkPos.field_77276_a; x <= maxChunkPos.field_77276_a; ++x) {
            for (int z = minChunkPos.field_77275_b; z <= maxChunkPos.field_77275_b; ++z) {
                chunkPoses.add(new ChunkPos(x, z));
            }
        }
        return chunkPoses;
    }

    private void updatePoses() {
        this.framePoses.clear();
        this.frameBoxPosesCount = 0;
        this.toCheck.clear();
        this.firstCheckedPoses.clear();
        this.firstChecked = false;
        this.frameBreakBlockPoses.clear();
        this.framePlaceFramePoses.clear();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BCBuildersBlocks.quarry && this.frameBox.isInitialized()) {
            List<BlockPos> blocksInArea = this.frameBox.getBlocksInArea();
            blocksInArea.sort(BlockUtil.uniqueBlockPosComparator(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.field_174879_c).func_177951_i(arg_0))));
            this.frameBoxPosesCount = blocksInArea.size();
            this.toCheck.addAll(blocksInArea);
            this.framePoses.addAll(this.getFramePositions());
            ChunkLoaderManager.loadChunksForTile(this);
        }
    }

    public void func_73660_a() {
        long max;
        if (this.drillPos == null) {
            this.collisionBoxes = ImmutableList.of();
            this.collisionDrillPos = null;
        }
        if (this.field_145850_b.field_72995_K) {
            this.prevClientDrillPos = this.clientDrillPos;
            this.clientDrillPos = this.drillPos;
            if (this.currentTask != null) {
                this.currentTask.clientTick();
            }
            return;
        }
        if (!this.frameBox.isInitialized() || !this.miningBox.isInitialized()) {
            return;
        }
        if (!this.toCheck.isEmpty()) {
            for (int i = 0; i < (this.firstChecked ? 10 : 500); ++i) {
                BlockPos blockPos = this.toCheck.pollFirst();
                this.check(blockPos);
                this.toCheck.addLast(blockPos);
            }
        }
        if (!this.firstChecked) {
            return;
        }
        if (this.battery.getStored() > this.battery.getCapacity() / 2L) {
            max = MAX_POWER_PER_TICK;
        } else {
            long roundedUp = this.battery.getStored() + MjAPI.MJ / 2L;
            max = roundedUp > Long.MAX_VALUE / MAX_POWER_PER_TICK ? BigInteger.valueOf(roundedUp).multiply(BigInteger.valueOf(MAX_POWER_PER_TICK)).divide(BigInteger.valueOf(this.battery.getCapacity() / 2L)).longValue() : MAX_POWER_PER_TICK * roundedUp / (this.battery.getCapacity() / 2L);
            max = MathUtil.clamp(max, 0L, MAX_POWER_PER_TICK);
        }
        this.debugPowerRate = max;
        this.blockPercentSoFar = 0.0;
        this.moveDistanceSoFar = 0.0;
        int maxTasks = Math.max(1, (int)(max * (long)BCBuildersConfig.quarryMaxTasksPerTick / MAX_POWER_PER_TICK));
        boolean sendUpdate = false;
        block1: for (int i = 0; i < maxTasks; ++i) {
            if (this.currentTask != null) {
                long added;
                long needed = this.currentTask.getRequiredPowerThisTick();
                int mult = BCBuildersConfig.quarryTaskPowerDivisor;
                if (mult > 0) {
                    long nNeeded = needed * (long)(mult + i) / (long)mult;
                    long leftover = needed * (long)(mult + i) % (long)mult;
                    long power = this.battery.extractPower(0L, Math.min(max, nNeeded));
                    max -= power;
                    added = power * (long)mult / (long)(mult + i);
                    if (leftover > 0L) {
                        ++added;
                    }
                } else {
                    added = this.battery.extractPower(0L, Math.min(max, needed));
                    max -= added;
                }
                if (this.currentTask.addPower(added)) {
                    this.currentTask = null;
                } else {
                    sendUpdate = true;
                    break;
                }
            }
            if (!this.frameBreakBlockPoses.isEmpty()) {
                BlockPos blockPos = this.frameBreakBlockPoses.iterator().next();
                if (this.canMine(blockPos)) {
                    this.drillPos = null;
                    this.currentTask = new TaskBreakBlock(blockPos);
                    sendUpdate = true;
                }
                this.check(blockPos);
                continue;
            }
            if (!this.framePlaceFramePoses.isEmpty()) {
                for (BlockPos blockPos : this.framePoses) {
                    if (!this.framePlaceFramePoses.contains(blockPos)) continue;
                    this.check(blockPos);
                    if (!this.framePlaceFramePoses.contains(blockPos)) continue;
                    this.drillPos = null;
                    this.currentTask = new TaskAddFrame(blockPos);
                    sendUpdate = true;
                    continue block1;
                }
            }
            if (this.boxIterator == null || this.drillPos == null) {
                this.boxIterator = this.createBoxIterator();
                while (!(!this.canMoveThrough(this.boxIterator.getCurrent()) && this.canMine(this.boxIterator.getCurrent()) && this.canMoveDownTo(this.boxIterator.getCurrent()) || this.boxIterator.advance() == null)) {
                }
                this.drillPos = new Vec3d((Vec3i)this.miningBox.closestInsideTo(this.field_174879_c));
            }
            if (this.boxIterator == null || !this.boxIterator.hasNext()) continue;
            while (!(!this.canMoveThrough(this.boxIterator.getCurrent()) && this.canMine(this.boxIterator.getCurrent()) && this.canMoveDownTo(this.boxIterator.getCurrent()) || this.boxIterator.advance() == null)) {
            }
            if (!this.boxIterator.hasNext()) continue;
            boolean found = false;
            Vec3d vec3d = new Vec3d((Vec3i)this.boxIterator.getCurrent());
            if (this.drillPos.func_72436_e(vec3d) >= 1.0) {
                this.currentTask = new TaskMoveDrill(this.drillPos, new Vec3d((Vec3i)this.boxIterator.getCurrent()));
                found = true;
            } else if (this.canMine(this.boxIterator.getCurrent())) {
                this.currentTask = new TaskBreakBlock(this.boxIterator.getCurrent());
                found = true;
            }
            if (found) {
                sendUpdate = true;
                continue;
            }
            AxisAlignedBB box = this.miningBox.getBoundingBox();
            if (box.field_72336_d - box.field_72340_a != 63.0 || box.field_72334_f - box.field_72339_c != 63.0) continue;
            AdvancementUtil.unlockAdvancement(this.getOwner().getId(), ADVANCEMENT_COMPLETE);
        }
        this.debugPowerRate -= max;
        if (sendUpdate) {
            this.sendNetworkUpdate(NET_RENDER_DATA);
        }
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        if (this.drillPos != null && this.drillPos != this.collisionDrillPos && this.frameBox.isInitialized()) {
            Vec3d max = VecUtil.convertCenter((Vec3i)this.frameBox.max());
            Vec3d min = VecUtil.replaceValue(VecUtil.convertCenter((Vec3i)this.frameBox.min()), EnumFacing.Axis.Y, max.field_72448_b);
            this.collisionBoxes = ImmutableList.of((Object)BoundingBoxUtil.makeFrom(VecUtil.replaceValue(min, EnumFacing.Axis.X, this.drillPos.field_72450_a + 0.5), VecUtil.replaceValue(max, EnumFacing.Axis.X, this.drillPos.field_72450_a + 0.5), 0.25), (Object)BoundingBoxUtil.makeFrom(VecUtil.replaceValue(min, EnumFacing.Axis.Z, this.drillPos.field_72449_c + 0.5), VecUtil.replaceValue(max, EnumFacing.Axis.Z, this.drillPos.field_72449_c + 0.5), 0.25), (Object)BoundingBoxUtil.makeFrom(this.drillPos.func_72441_c(0.5, 0.0, 0.5), VecUtil.replaceValue(this.drillPos, EnumFacing.Axis.Y, max.field_72448_b).func_72441_c(0.5, 0.0, 0.5), 0.25));
            this.collisionDrillPos = this.drillPos;
        }
        return this.collisionBoxes;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("box", (NBTBase)this.miningBox.writeToNBT());
        nbt.func_74782_a("frame", (NBTBase)this.frameBox.writeToNBT());
        if (this.boxIterator != null) {
            nbt.func_74782_a("boxIterator", (NBTBase)this.boxIterator.writeToNbt());
        }
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        if (this.currentTask != null) {
            nbt.func_74774_a("currentTaskId", (byte)Arrays.stream(EnumTaskType.values()).filter(type -> type.clazz == this.currentTask.getClass()).findFirst().orElseThrow(IllegalStateException::new).ordinal());
            nbt.func_74782_a("currentTaskData", (NBTBase)this.currentTask.serializeNBT());
        }
        if (this.drillPos != null) {
            nbt.func_74782_a("drillPos", (NBTBase)NBTUtilBC.writeVec3d(this.drillPos));
        }
        nbt.func_74757_a("firstChecked", this.firstChecked);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.miningBox.initialize(nbt.func_74775_l("box"));
        this.frameBox.initialize(nbt.func_74775_l("frame"));
        this.boxIterator = BoxIterator.readFromNbt(nbt.func_74775_l("boxIterator"));
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        if (nbt.func_74764_b("currentTask")) {
            this.currentTask = EnumTaskType.values()[nbt.func_74771_c((String)"currentTaskId")].supplier.apply(this);
            this.currentTask.readFromNBT(nbt.func_74775_l("currentTaskData"));
        } else {
            this.currentTask = null;
        }
        this.drillPos = NBTUtilBC.readVec3d(nbt.func_74781_a("drillPos"));
        this.firstChecked = nbt.func_74767_n("firstChecked");
        if (this.drillPos != null) {
            Vec3d vec3d = new Vec3d((Vec3i)this.func_174877_v());
            if (this.drillPos.func_72436_e(vec3d) > 1048576.0) {
                this.drillPos = null;
            }
        }
        boolean isValid = false;
        if (this.frameBox.isInitialized() && this.miningBox.isInitialized()) {
            isValid = true;
            EnumFacing validFace = null;
            for (EnumFacing face : EnumFacing.values()) {
                if (face.func_176740_k() == EnumFacing.Axis.Y || !this.frameBox.isOnEdge(this.func_174877_v().func_177972_a(face))) continue;
                validFace = face;
                break;
            }
            if (validFace == null) {
                isValid = false;
            } else {
                int fx0 = this.frameBox.min().func_177958_n();
                int fy0 = this.frameBox.min().func_177956_o();
                int fz0 = this.frameBox.min().func_177952_p();
                int fx1 = this.frameBox.max().func_177958_n();
                int fy1 = this.frameBox.max().func_177956_o();
                int fz1 = this.frameBox.max().func_177952_p();
                int mx0 = this.miningBox.min().func_177958_n();
                int my0 = this.miningBox.min().func_177956_o();
                int mz0 = this.miningBox.min().func_177952_p();
                int mx1 = this.miningBox.max().func_177958_n();
                int my1 = this.miningBox.max().func_177956_o();
                int mz1 = this.miningBox.max().func_177952_p();
                boolean bl = isValid = fx0 + 1 == mx0 && fx1 - 1 == mx1 && fz0 + 1 == mz0 && fz1 - 1 == mz1 && fy0 >= my0 && fy1 - 1 == my1;
            }
        }
        if (!isValid) {
            this.frameBox.reset();
            this.miningBox.reset();
            this.drillPos = null;
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            this.frameBox.writeData(buffer);
            this.miningBox.writeData(buffer);
            buffer.writeBoolean(this.drillPos != null);
            if (this.drillPos != null) {
                MessageUtil.writeVec3d(buffer, this.drillPos);
            }
            buffer.writeBoolean(this.currentTask != null);
            if (this.currentTask != null) {
                buffer.writeByte((byte)Arrays.stream(EnumTaskType.values()).filter(type -> type.clazz == this.currentTask.getClass()).findFirst().orElseThrow(IllegalStateException::new).ordinal());
                for (int i = 0; i < 2; ++i) {
                    this.currentTask.toBytes(buffer);
                }
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            this.frameBox.readData(buffer);
            this.miningBox.readData(buffer);
            this.drillPos = buffer.readBoolean() ? MessageUtil.readVec3d(buffer) : null;
            if (buffer.readBoolean()) {
                byte taskId = buffer.readByte();
                Task task = EnumTaskType.values()[taskId].supplier.apply(this);
                task.fromBytes(buffer);
                if (this.currentTask == null || !this.currentTask.equals(task)) {
                    this.currentTask = task;
                    Task tempTask = EnumTaskType.values()[taskId].supplier.apply(this);
                    tempTask.fromBytes(buffer);
                } else {
                    this.currentTask.fromBytes(buffer);
                }
            } else {
                this.currentTask = null;
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("rate = " + LocaleUtil.localizeRfFlow(this.debugPowerRate));
        left.add("frameBox");
        left.add(" - min = " + this.frameBox.min());
        left.add(" - max = " + this.frameBox.max());
        left.add("miningBox:");
        left.add(" - min = " + this.miningBox.min());
        left.add(" - max = " + this.miningBox.max());
        left.add("firstCheckedPoses = " + this.firstCheckedPoses.size());
        left.add("frameBoxPosesCount = " + this.frameBoxPosesCount);
        left.add("firstChecked = " + this.firstChecked);
        BoxIterator iter = this.boxIterator;
        left.add("current = " + (iter == null ? "null" : iter.getCurrent()));
        Task task = this.currentTask;
        if (task != null) {
            left.add("task:");
            left.add(" - class = " + task.getClass().getName());
            left.add(" - power = " + LocaleUtil.localizeRf(task.power));
            left.add(" - target = " + LocaleUtil.localizeRf(task.getTarget()));
        } else {
            left.add("task = null");
        }
        left.add("drill = " + this.drillPos);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BoundingBoxUtil.makeFrom(this.field_174879_c, this.miningBox);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public DetachedRenderer.IDetachedRenderer getDebugRenderer() {
        return new AdvDebuggerQuarry(this);
    }

    private class TaskMoveDrill
    extends Task {
        public Vec3d from;
        public Vec3d to;

        TaskMoveDrill() {
            this.from = Vec3d.field_186680_a;
            this.to = Vec3d.field_186680_a;
        }

        TaskMoveDrill(Vec3d from, Vec3d to) {
            this.from = Vec3d.field_186680_a;
            this.to = Vec3d.field_186680_a;
            this.from = from;
            this.to = to;
        }

        @Override
        NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("from", (NBTBase)NBTUtilBC.writeVec3d(this.from));
            nbt.func_74782_a("to", (NBTBase)NBTUtilBC.writeVec3d(this.to));
            return nbt;
        }

        @Override
        void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.from = NBTUtilBC.readVec3d(nbt.func_74781_a("from"));
            this.to = NBTUtilBC.readVec3d(nbt.func_74781_a("to"));
            if (this.from == null || this.to == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            MessageUtil.writeVec3d(buffer, this.from);
            MessageUtil.writeVec3d(buffer, this.to);
        }

        @Override
        void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.from = MessageUtil.readVec3d(buffer);
            this.to = MessageUtil.readVec3d(buffer);
        }

        @Override
        public long getTarget() {
            return (long)(this.from.func_72438_d(this.to) * 20.0 * (double)MjAPI.MJ);
        }

        @Override
        public long getRequiredPowerThisTick() {
            long req = Math.max(0L, this.getTarget() - this.power);
            double max = BCBuildersConfig.quarryMaxFrameMoveSpeed;
            if (max < 0.1) {
                return req;
            }
            max /= 20.0;
            if ((max -= TileQuarry.this.moveDistanceSoFar) <= 0.0) {
                return 0L;
            }
            return Math.min(req, (long)(max * 20.0 * (double)MjAPI.MJ));
        }

        @Override
        protected boolean onReceivePower(long added, long target) {
            TileQuarry.this.moveDistanceSoFar = TileQuarry.this.moveDistanceSoFar + (double)added / (double)MjAPI.MJ;
            TileQuarry.this.drillPos = this.from.func_186678_a(1.0 - (double)this.power / (double)target).func_178787_e(this.to.func_186678_a((double)this.power / (double)target));
            return false;
        }

        @Override
        protected boolean finish(long added, long target) {
            TileQuarry.this.moveDistanceSoFar = TileQuarry.this.moveDistanceSoFar + (double)added / (double)MjAPI.MJ;
            TileQuarry.this.drillPos = this.to;
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            TaskMoveDrill other = (TaskMoveDrill)o;
            return this.from.equals((Object)other.from) && this.to.equals((Object)other.to);
        }
    }

    public class TaskAddFrame
    extends Task {
        public BlockPos framePos;

        TaskAddFrame() {
            this.framePos = BlockPos.field_177992_a;
        }

        TaskAddFrame(BlockPos framePos) {
            this.framePos = BlockPos.field_177992_a;
            this.framePos = framePos;
        }

        @Override
        NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("framePos", (NBTBase)NBTUtilBC.writeBlockPos(this.framePos));
            return nbt;
        }

        @Override
        void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.framePos = NBTUtilBC.readBlockPos(nbt.func_74781_a("framePos"));
            if (this.framePos == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            buffer.func_179255_a(this.framePos);
        }

        @Override
        void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.framePos = buffer.func_179259_c();
        }

        @Override
        public long getTarget() {
            return 24L * MjAPI.MJ;
        }

        @Override
        protected boolean onReceivePower(long added, long target) {
            return TileQuarry.this.canIgnoreInFrameBox(this.framePos);
        }

        @Override
        protected boolean finish(long added, long target) {
            if (TileQuarry.this.canIgnoreInFrameBox(this.framePos)) {
                return false;
            }
            TileQuarry.this.field_145850_b.func_175656_a(this.framePos, BCBuildersBlocks.frame.func_176223_P());
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            return this.framePos.equals((Object)((TaskAddFrame)o).framePos);
        }
    }

    public class TaskBreakBlock
    extends Task {
        public BlockPos breakPos;

        TaskBreakBlock() {
            this.breakPos = BlockPos.field_177992_a;
        }

        TaskBreakBlock(BlockPos pos) {
            this.breakPos = BlockPos.field_177992_a;
            this.breakPos = pos;
        }

        @Override
        NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("breakPos", (NBTBase)NBTUtilBC.writeBlockPos(this.breakPos));
            return nbt;
        }

        @Override
        void readFromNBT(NBTTagCompound nbt) {
            super.readFromNBT(nbt);
            this.breakPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("breakPos"));
            if (this.breakPos == null) {
                TileQuarry.this.currentTask = null;
            }
        }

        @Override
        void toBytes(PacketBufferBC buffer) {
            super.toBytes(buffer);
            buffer.func_179255_a(this.breakPos);
        }

        @Override
        void fromBytes(PacketBufferBC buffer) {
            super.fromBytes(buffer);
            this.breakPos = buffer.func_179259_c();
        }

        @Override
        public long getTarget() {
            return BlockUtil.computeBlockBreakPower(TileQuarry.this.field_145850_b, this.breakPos);
        }

        @Override
        public long getRequiredPowerThisTick() {
            long target = this.getTarget();
            long req = Math.max(0L, target - this.power);
            double rate = BCBuildersConfig.quarryMaxBlockMineRate;
            if (rate < 0.1) {
                return req;
            }
            rate /= 20.0;
            if ((rate -= TileQuarry.this.blockPercentSoFar) <= 0.0) {
                return 0L;
            }
            return Math.min(req, (long)((double)target * rate));
        }

        @Override
        protected boolean onReceivePower(long added, long target) {
            TileQuarry.this.blockPercentSoFar = TileQuarry.this.blockPercentSoFar + (double)added / (double)target;
            if (!TileQuarry.this.field_145850_b.func_175623_d(this.breakPos)) {
                TileQuarry.this.field_145850_b.func_175715_c(this.breakPos.hashCode(), this.breakPos, (int)(this.power * 9L / this.getTarget()));
                return false;
            }
            return true;
        }

        @Override
        protected boolean finish(long added, long target) {
            TileQuarry.this.blockPercentSoFar = TileQuarry.this.blockPercentSoFar + (double)added / (double)target;
            if (!TileQuarry.this.canMine(this.breakPos)) {
                return true;
            }
            TileQuarry.this.field_145850_b.func_175715_c(this.breakPos.hashCode(), this.breakPos, -1);
            Optional<List<ItemStack>> stacks = BlockUtil.breakBlockAndGetDrops((WorldServer)TileQuarry.this.field_145850_b, this.breakPos, new ItemStack(Items.field_151046_w), TileQuarry.this.getOwner(), true);
            if (stacks.isPresent() && TileQuarry.this.drillPos != null) {
                stacks.get().forEach(stack -> InventoryUtil.addToBestAcceptor(TileQuarry.this.field_145850_b, TileQuarry.this.field_174879_c, null, stack));
            }
            TileQuarry.this.check(this.breakPos);
            return stacks.isPresent();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            return this.breakPos.equals((Object)((TaskBreakBlock)o).breakPos);
        }
    }

    private abstract class Task {
        public long power;
        public long clientPower;
        public long prevClientPower;

        private Task() {
        }

        NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("power", this.power);
            return nbt;
        }

        void readFromNBT(NBTTagCompound nbt) {
            this.power = nbt.func_74763_f("power");
            if (this.power < 0L) {
                this.power = 0L;
            }
        }

        void toBytes(PacketBufferBC buffer) {
            buffer.writeLong(this.power);
        }

        void fromBytes(PacketBufferBC buffer) {
            this.power = buffer.readLong();
        }

        void clientTick() {
            this.prevClientPower = this.clientPower;
            this.clientPower = this.power;
        }

        public abstract long getTarget();

        public long getRequiredPowerThisTick() {
            return Math.max(0L, this.getTarget() - this.power);
        }

        protected abstract boolean onReceivePower(long var1, long var3);

        protected abstract boolean finish(long var1, long var3);

        final boolean addPower(long microJoules) {
            this.power += microJoules;
            long target = this.getTarget();
            if (this.power >= target) {
                if (!this.finish(microJoules, target)) {
                    TileQuarry.this.battery.addPower(Math.min(this.power, TileQuarry.this.battery.getCapacity() - TileQuarry.this.battery.getStored()), false);
                }
                return true;
            }
            return this.onReceivePower(microJoules, target);
        }
    }

    private static enum EnumTaskType {
        BREAK_BLOCK(TaskBreakBlock.class, quarry -> (TileQuarry)quarry.new TaskBreakBlock()),
        ADD_FRAME(TaskAddFrame.class, quarry -> (TileQuarry)quarry.new TaskAddFrame()),
        MOVE_DRILL(TaskMoveDrill.class, quarry -> (TileQuarry)quarry.new TaskMoveDrill());

        public final Class<? extends Task> clazz;
        public final Function<TileQuarry, Task> supplier;

        private EnumTaskType(Class<? extends Task> clazz, Function<TileQuarry, Task> supplier) {
            this.clazz = clazz;
            this.supplier = supplier;
        }
    }
}

