/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.forestry.pipe;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.core.compat.CompatUtils;
import buildcraft.core.compat.module.forestry.pipe.ContainerPropolisPipe;
import buildcraft.core.compat.module.forestry.pipe.ForestryPipes;
import buildcraft.core.compat.network.CompatGui;
import buildcraft.core.compat.network.IGuiCreator;
import buildcraft.lib.cap.CapabilityHelper;
import forestry.api.core.ILocatable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.GeneticCapabilities;
import forestry.api.genetics.IFilterLogic;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.tiles.IFilterContainer;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeBehaviourPropolis
extends PipeBehaviour
implements IFilterContainer,
IFilterLogic.INetworkHandler,
IGuiCreator {
    private final CapabilityHelper caps = new CapabilityHelper();
    private final IFilterLogic filter = AlleleManager.filterRegistry.createLogic((ILocatable)this, (IFilterLogic.INetworkHandler)this);

    public PipeBehaviourPropolis(IPipe pipe) {
        super(pipe);
        this.caps.addCapabilityInstance(GeneticCapabilities.FILTER_LOGIC, this.filter, EnumPipePart.VALUES);
        this.caps.addCapabilityInstance(CompatUtils.CAP_GUI_CREATOR, this, EnumPipePart.CENTER);
    }

    public PipeBehaviourPropolis(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.caps.addCapabilityInstance(GeneticCapabilities.FILTER_LOGIC, this.filter, EnumPipePart.VALUES);
        this.caps.addCapabilityInstance(CompatUtils.CAP_GUI_CREATOR, this, EnumPipePart.CENTER);
        this.filter.readFromNBT(nbt.func_74775_l("filter"));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("filter", (NBTBase)this.filter.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            this.filter.readGuiData(buffer);
        }
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            this.filter.writeGuiData(buffer);
        }
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        T value = this.caps.getCapability(capability, facing);
        if (value != null) {
            return value;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        return face == null ? 0 : face.ordinal() + 1;
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (!this.getWorldObj().field_72995_K) {
            CompatGui.FORESTRY_PROPOLIS_PIPE.openGui(player, this.pipe.getHolder().getPipePos());
        }
        return true;
    }

    @PipeEventHandler
    public void sideCheck(PipeEventItem.SideCheck event) {
        ItemStack stack = event.stack;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.filter.isValid(stack, face)) {
                event.disallow(face);
                continue;
            }
            if (this.filter.getRule(face) != DefaultFilterRuleType.ANYTHING) continue;
            event.decreasePriority(face);
        }
    }

    public BlockPos getCoordinates() {
        return this.pipe.getHolder().getPipePos();
    }

    public World getWorldObj() {
        return this.pipe.getHolder().getPipeWorld();
    }

    public String getUnlocalizedTitle() {
        return ForestryPipes.pipeItemPropolis.func_77658_a() + ".name";
    }

    @Nullable
    public IInventory getBuffer() {
        return null;
    }

    public TileEntity getTileEntity() {
        return this.pipe.getHolder().getPipeTile();
    }

    public IFilterLogic getLogic() {
        return this.filter;
    }

    public void sendToPlayers(IFilterLogic logic, WorldServer server, EntityPlayer currentPlayer) {
        for (EntityPlayer player : server.field_73010_i) {
            ContainerGeneticFilter currentContainer;
            ContainerGeneticFilter otherContainer;
            if (player == currentPlayer || !(player.field_71070_bA instanceof ContainerGeneticFilter) || !(otherContainer = (ContainerGeneticFilter)player.field_71070_bA).hasSameTile(currentContainer = (ContainerGeneticFilter)currentPlayer.field_71070_bA)) continue;
            otherContainer.setGuiNeedsUpdate(true);
        }
    }

    @Override
    public Enum<?> getGuiType() {
        return CompatGui.FORESTRY_PROPOLIS_PIPE;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(int data, EntityPlayer player) {
        return new ContainerPropolisPipe(this, player);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(int data, EntityPlayer player) {
        return new GuiGeneticFilter((IFilterContainer)this, player.field_71071_by);
    }
}

