/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.ic2.exp;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.compat.module.ic2.exp.ExpIC2Statements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import ic2.api.energy.tile.IChargingSlot;
import ic2.api.energy.tile.IDischargingSlot;
import ic2.api.item.ElectricItem;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Energy;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ExpTriggerPowerItem
extends BCStatement
implements ITriggerExternal {
    private final boolean charging;
    private final int id;

    public ExpTriggerPowerItem(boolean charging, int id) {
        super("buildcraft:eu" + (charging ? "Charge" : "Discharge") + id);
        this.charging = charging;
        this.id = id;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        if (this.id == 1) {
            return BCCoreSprites.CHARGE_LOW;
        }
        if (this.id == 2) {
            return BCCoreSprites.CHARGE_HIGH;
        }
        if (this.charging) {
            return BCCoreSprites.CHARGE_FULL;
        }
        return BCCoreSprites.CHARGE_EMPTY;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.machine.eu." + (this.charging ? "charge." : "discharge.") + this.id);
    }

    private static Energy getEnergy(TileEntity tile) {
        if (tile instanceof TileEntityElectricMachine && ((TileEntityBlock)tile).hasComponent(Energy.class)) {
            return (Energy)((TileEntityBlock)tile).getComponent(Energy.class);
        }
        return null;
    }

    private static List<InvSlot> getSlots(TileEntity tile) {
        Energy energy = ExpTriggerPowerItem.getEnergy(tile);
        if (energy == null) {
            return null;
        }
        try {
            Field f = Energy.class.getDeclaredField("managedSlots");
            f.setAccessible(true);
            return (List)f.get(energy);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isTriggeringTile(TileEntity tile, boolean charge) {
        if (tile instanceof TileEntityElectricBlock) {
            return true;
        }
        List<InvSlot> slots = ExpTriggerPowerItem.getSlots(tile);
        if (slots != null) {
            for (InvSlot slot : slots) {
                if (slot instanceof IChargingSlot && charge) {
                    return true;
                }
                if (!(slot instanceof IDischargingSlot) || charge) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock block = (TileEntityElectricBlock)target;
            if (this.charging) {
                double charge = ElectricItem.manager.getCharge(block.chargeSlot.get());
                double max = ElectricItem.manager.getMaxCharge(block.chargeSlot.get());
                double ratio = charge / max;
                if (max != 0.0) {
                    if (this.id == 0 && ratio == 1.0) {
                        return true;
                    }
                    if (this.id == 1 && ratio <= 0.05) {
                        return true;
                    }
                    if (this.id == 2 && ratio >= 0.95) {
                        return true;
                    }
                }
            } else {
                double charge = ElectricItem.manager.getCharge(block.dischargeSlot.get());
                double max = ElectricItem.manager.getMaxCharge(block.dischargeSlot.get());
                double ratio = charge / max;
                if (max != 0.0) {
                    if (this.id == 0 && ratio == 0.0) {
                        return true;
                    }
                    if (this.id == 1 && ratio <= 0.05) {
                        return true;
                    }
                    if (this.id == 2 && ratio >= 0.95) {
                        return true;
                    }
                }
            }
        } else {
            List<InvSlot> slots = ExpTriggerPowerItem.getSlots(target);
            if (slots != null) {
                for (InvSlot slot : slots) {
                    double ratio;
                    double max;
                    double charge;
                    if (slot == null) continue;
                    if (slot instanceof IChargingSlot && this.charging) {
                        charge = ElectricItem.manager.getCharge(slot.get());
                        max = ElectricItem.manager.getMaxCharge(slot.get());
                        ratio = charge / max;
                        if (max == 0.0) continue;
                        if (this.id == 0 && ratio == 1.0) {
                            return true;
                        }
                        if (this.id == 1 && ratio <= 0.05) {
                            return true;
                        }
                        if (this.id != 2 || !(ratio >= 0.95)) continue;
                        return true;
                    }
                    if (!(slot instanceof IDischargingSlot) || this.charging) continue;
                    charge = ElectricItem.manager.getCharge(slot.get());
                    max = ElectricItem.manager.getMaxCharge(slot.get());
                    ratio = charge / max;
                    if (max == 0.0) continue;
                    if (this.id == 0 && ratio == 0.0) {
                        return true;
                    }
                    if (this.id == 1 && ratio <= 0.05) {
                        return true;
                    }
                    if (this.id != 2 || !(ratio >= 0.95)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IStatement[] getPossible() {
        return this.charging ? ExpIC2Statements.CHARGE_ITEM : ExpIC2Statements.DISCHARGE_ITEM;
    }
}

