/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.jei.silicon;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.core.compat.module.jei.BCPluginJEI;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrapperAssemblyTable
implements IRecipeWrapper {
    private final AssemblyRecipeBasic recipe;
    private final IDrawableAnimated progressBar;
    private final List<List<ItemStack>> inputs;
    private final List<ItemStack> outputs;

    public WrapperAssemblyTable(AssemblyRecipeBasic recipe) {
        this.recipe = recipe;
        ArrayList _inputs = Lists.newArrayList();
        for (IngredientStack in : recipe.getInputsFor(ItemStack.field_190927_a)) {
            ArrayList<ItemStack> inner = new ArrayList<ItemStack>();
            for (ItemStack matching : in.ingredient.func_193365_a()) {
                matching = matching.func_77946_l();
                matching.func_190920_e(in.count);
                inner.add(matching);
            }
            _inputs.add(inner);
        }
        this.inputs = ImmutableList.copyOf((Collection)_inputs);
        this.outputs = ImmutableList.copyOf(recipe.getOutputPreviews());
        IGuiHelper guiHelper = BCPluginJEI.registry.getJeiHelpers().getGuiHelper();
        ResourceLocation backgroundLocation = new ResourceLocation("buildcraftsilicon", "textures/gui/assembly_table.png");
        IDrawableStatic progressDrawable = guiHelper.createDrawable(backgroundLocation, 176, 48, 4, 71, 10, 0, 0, 0);
        long mj = this.recipe.getRequiredMicroJoulesFor(ItemStack.field_190927_a);
        this.progressBar = guiHelper.createAnimatedDrawable(progressDrawable, (int)Math.max(10L, mj / MjAPI.MJ / 50L), IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progressBar.draw(minecraft, 81, 2);
        long mj = this.recipe.getRequiredMicroJoulesFor(ItemStack.field_190927_a);
        minecraft.field_71466_p.func_78276_b(MjAPI.formatRFFromMj(mj) + " RF", 4, 0, Color.gray.getRGB());
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

