/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.network;

import buildcraft.core.compat.BCCompat;
import buildcraft.core.compat.CompatUtils;
import buildcraft.core.compat.network.IGuiCreator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;

public enum CompatGui {
    FORESTRY_PROPOLIS_PIPE(IGuiTarget.TILE);

    static final CompatGui[] VALUES;
    @SidedProxy(modId="buildcraftcompat")
    public static CommonProxy guiHandlerProxy;
    public final IGuiTarget target;

    private CompatGui(IGuiTarget target) {
        this.target = target;
    }

    public void openGui(EntityPlayer player) {
        this.openGui(player, 0, 0, 0, 0);
    }

    public void openGui(EntityPlayer player, BlockPos pos) {
        this.openGui(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0);
    }

    public void openGui(EntityPlayer player, int x, int y, int z) {
        this.openGui(player, x, y, z, 0);
    }

    public void openGui(EntityPlayer player, int data) {
        this.openGui(player, 0, 0, 0, data);
    }

    public void openGui(EntityPlayer player, BlockPos pos, int data) {
        this.openGui(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), data);
    }

    public void openGui(EntityPlayer player, int x, int y, int z, int data) {
        player.openGui((Object)BCCompat.instance, CompatGui.packGui(this, data), player.field_70170_p, x, y, z);
    }

    protected static int packGui(Enum<?> gui, int data) {
        if (data < 0 || data > 0xFFFFFF) {
            throw new IllegalArgumentException("Data must be between 0 and 0xFF_FF_FF (inclusive)");
        }
        return data << 8 | gui.ordinal();
    }

    @Nullable
    protected static CompatGui getGui(int id) {
        if ((id &= 0xFF) < 0 || id >= VALUES.length) {
            return null;
        }
        return VALUES[id];
    }

    protected static int getData(int id) {
        return id >>> 8;
    }

    static {
        VALUES = CompatGui.values();
    }

    public static class ClientProxy
    extends CommonProxy {
        @Nullable
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            IGuiCreator creator = ClientProxy.getGuiCreator(id, player, world, x, y, z);
            if (creator == null) {
                return null;
            }
            return creator.getClientGuiElement(CompatGui.getData(id), player);
        }
    }

    public static class ServerProxy
    extends CommonProxy {
        @Nullable
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }
    }

    public static abstract class CommonProxy
    implements IGuiHandler {
        @Nullable
        protected static IGuiCreator getGuiCreator(int id, EntityPlayer player, World world, int x, int y, int z) {
            CompatGui type = CompatGui.getGui(id);
            int data = CompatGui.getData(id);
            if (type == null) {
                return null;
            }
            IGuiCreator creator = type.target.getCreator(player, world, x, y, z, data);
            if (creator == null || creator.getGuiType() != type) {
                return null;
            }
            return creator;
        }

        @Nullable
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            IGuiCreator creator = CommonProxy.getGuiCreator(id, player, world, x, y, z);
            if (creator == null) {
                return null;
            }
            return creator.getServerGuiElement(CompatGui.getData(id), player);
        }
    }

    @FunctionalInterface
    public static interface IGuiTarget {
        public static final IGuiTarget TILE = (player, world, x, y, z, data) -> {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (tile instanceof IGuiCreator) {
                return (IGuiCreator)tile;
            }
            if (tile != null) {
                return (IGuiCreator)tile.getCapability(CompatUtils.CAP_GUI_CREATOR, null);
            }
            return null;
        };

        @Nullable
        public IGuiCreator getCreator(EntityPlayer var1, World var2, int var3, int var4, int var5, int var6);
    }
}

