/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.TriggerPowerHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class TriggerPower
extends BCStatement
implements ITriggerInternal,
ITriggerExternal {
    private final boolean high;

    public TriggerPower(boolean high) {
        super("buildcraft:energyStored" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return this.high ? BCCoreSprites.TRIGGER_POWER_HIGH : BCCoreSprites.TRIGGER_POWER_LOW;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.machine.energyStored." + (this.high ? "high" : "low"));
    }

    public boolean isTriggeredMjConnector(IEnergyStorage readable) {
        if (readable == null) {
            return false;
        }
        long stored = readable.getEnergyStored();
        long max = readable.getMaxEnergyStored();
        if (max > 0L) {
            double level = (double)stored / (double)max;
            if (this.high) {
                return level > 0.95;
            }
            return level < 0.05;
        }
        return false;
    }

    public static boolean isTriggeringTile(TileEntity tile) {
        return TriggerPower.isTriggeringTile(tile, null);
    }

    public static boolean isTriggeringTile(TileEntity tile, EnumFacing face) {
        if (Loader.isModLoaded((String)"buildcrafttransport")) {
            return TriggerPowerHandler.isTriggeringTile(tile, face);
        }
        return tile.hasCapability(CapabilityEnergy.ENERGY, face);
    }

    protected boolean isActive(TileEntity tile, EnumPipePart side) {
        return this.isTriggeredMjConnector((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.face));
    }

    @Override
    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        return this.isActive(source.getTile(), EnumPipePart.CENTER);
    }

    @Override
    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        return this.isActive(target, EnumPipePart.fromFacing(side.func_176734_d()));
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.TRIGGER_POWER;
    }
}

