/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.BCModules;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.fluid.BCFluidBlock;
import buildcraft.lib.fluid.FluidManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.util.ResourceLocation;

public class BCEnergyFluids {
    public static BCFluid oil;
    public static BCFluid fuel;
    public static BCFluid[] crudeOil;
    public static BCFluid[] oilDense;
    public static BCFluid[] oilDistilled;
    public static BCFluid[] oilHeavy;
    public static BCFluid[] fuelDense;
    public static BCFluid[] fuelLight;
    public static BCFluid[] fuelMixedHeavy;
    public static BCFluid[] fuelMixedLight;
    public static BCFluid[] fuelGaseous;
    public static BCFluid[] oilResidue;
    public static final List<BCFluid> allFluids;

    public static void preInit() {
        int[][] data = new int[][]{{900, 2000, 3, 6, 0x505050, 328965, 1, 1}, {400, 600, 1, 8, 0xFFFF30, 14995200, 0, 1}};
        if (BCModules.FACTORY.isLoaded()) {
            BCEnergyFluids.crudeOil[0] = oil = BCEnergyFluids.defineFluid(data[0], "oil");
            BCEnergyFluids.fuelLight[0] = fuel = BCEnergyFluids.defineFluid(data[1], "fuel");
        }
    }

    private static BCFluid defineFluid(int[] data, String name) {
        int density = data[0];
        int baseViscosity = data[1];
        int baseQuanta = data[3];
        int texLight = data[4];
        int texDark = data[5];
        boolean sticky = BCEnergyConfig.oilIsSticky && data[6] == 1;
        boolean flammable = BCEnergyConfig.enableOilBurn && data[7] == 1;
        String fluidTexture = "buildcraftenergy:blocks/fluids/" + name;
        BCFluid def = new BCFluid(name, new ResourceLocation(fluidTexture + "_still"), new ResourceLocation(fluidTexture + "_flow"));
        def.setBlockName(name);
        def.setMapColour(BCEnergyFluids.getMapColor(texDark));
        def.setFlammable(flammable);
        def.setUnlocalizedName(name);
        def.setTemperature(300);
        def.setViscosity(baseViscosity);
        def.setDensity(density);
        def.setGaseous(def.getDensity() < 0);
        def.setColour(texLight, texDark);
        FluidManager.register(def);
        BCFluidBlock block = (BCFluidBlock)def.getBlock();
        block.func_149713_g(3);
        block.setSticky(sticky);
        block.setQuantaPerBlock(baseQuanta);
        allFluids.add(def);
        return def;
    }

    private static MapColor getMapColor(int color) {
        MapColor bestMapColor = MapColor.field_151646_E;
        int currentDifference = Integer.MAX_VALUE;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (MapColor mapColor : MapColor.field_76281_a) {
            int mb;
            int db;
            int mg;
            int dg;
            int mr;
            int dr;
            int difference;
            if (mapColor == null || mapColor.field_76291_p == 0 || (difference = (dr = (mr = mapColor.field_76291_p >> 16 & 0xFF) - r) * dr + (dg = (mg = mapColor.field_76291_p >> 8 & 0xFF) - g) * dg + (db = (mb = mapColor.field_76291_p & 0xFF) - b) * db) >= currentDifference) continue;
            currentDifference = difference;
            bestMapColor = mapColor;
        }
        return bestMapColor;
    }

    static {
        crudeOil = new BCFluid[1];
        oilDense = new BCFluid[0];
        oilDistilled = new BCFluid[0];
        oilHeavy = new BCFluid[0];
        fuelDense = new BCFluid[0];
        fuelLight = new BCFluid[1];
        fuelMixedHeavy = new BCFluid[0];
        fuelMixedLight = new BCFluid[0];
        fuelGaseous = new BCFluid[0];
        oilResidue = new BCFluid[0];
        allFluids = new ArrayList<BCFluid>();
    }
}

