/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.BCModules;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.BCEnergyFluids;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BCEnergyRecipes {
    public static void init() {
        BuildcraftFuelRegistry.coolant.addCoolant(FluidRegistry.WATER, 0.0023f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000), 1.5f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(new ItemStack(Blocks.field_150403_cj), new FluidStack(FluidRegistry.WATER, 1000), 2.0f);
        if (!BCEnergyConfig.disableEngineRecipes) {
            BCEnergyRecipes.addFuel(BCEnergyFluids.fuel, (int)(6L * MjAPI.MJ), 25000);
            BCEnergyRecipes.addFuel(BCEnergyFluids.oil, (int)(3L * MjAPI.MJ), 12500);
        }
        if (BCModules.FACTORY.isLoaded()) {
            BCEnergyRecipes.addDistillation(new FluidStack((Fluid)BCEnergyFluids.oil, 1), new FluidStack((Fluid)BCEnergyFluids.fuel, 1), 12L * MjAPI.MJ);
        }
    }

    private static void addFuel(Fluid in, int mmjPerTick, int ticksPerBucket) {
        BuildcraftFuelRegistry.fuel.addFuel(in, (long)mmjPerTick, ticksPerBucket);
    }

    private static void addDistillation(FluidStack _in, FluidStack _outLiquid, long mjCost) {
        IRefineryRecipeManager.IDistillationRecipe existing = BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getRecipeForInput(_in);
        if (existing != null) {
            throw new IllegalStateException("Already added distillation recipe for " + _in.getFluid().getName());
        }
        BuildcraftRecipeRegistry.refineryRecipes.addDistillationRecipe(_in, _outLiquid, mjCost);
    }
}

