/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import net.minecraftforge.energy.IEnergyStorage;

public class BCRfWrapper
implements IEnergyStorage {
    private MjBattery battery;
    private int maxRfReceive = -1;

    public BCRfWrapper(MjBattery battery) {
        this.battery = battery;
    }

    public BCRfWrapper(MjBattery battery, int maxRfReceive) {
        this.battery = battery;
        this.maxRfReceive = maxRfReceive;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int actualMaxReceive = this.maxRfReceive >= 0 ? Math.min(maxReceive, this.maxRfReceive) : maxReceive;
        long mjToAdd = (long)actualMaxReceive * MjAPI.MJ / (long)MjAPI.rfPerMj;
        long added = mjToAdd - this.battery.addPowerChecking(mjToAdd, simulate);
        return (int)(added * (long)MjAPI.rfPerMj / MjAPI.MJ);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)((long)MjAPI.rfPerMj * this.battery.getStored() / MjAPI.MJ);
    }

    public int getMaxEnergyStored() {
        return (int)((long)MjAPI.rfPerMj * this.battery.getCapacity() / MjAPI.MJ);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return !this.battery.isFull();
    }
}

