/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.event;

import buildcraft.api.core.BCLog;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.lib.fluid.BCFluid;
import java.lang.reflect.Field;
import java.time.Month;
import java.time.MonthDay;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.text.translation.LanguageMap;

public class ChristmasHandler {
    private static Boolean enabled;

    public static boolean isEnabled() {
        if (enabled == null) {
            throw new IllegalStateException("Unknown until init!");
        }
        return enabled;
    }

    private static void fmlPreInit() {
        enabled = BCEnergyConfig.christmasEventStatus.isEnabled(MonthDay.of(Month.DECEMBER, 25));
        if (ChristmasHandler.isEnabled()) {
            ChristmasHandler.setColours(0x505050, 328965, BCEnergyFluids.oil);
            ChristmasHandler.setColours(0xFFFF30, 14995200, BCEnergyFluids.fuel);
        }
    }

    public static void fmlPreInitDedicatedServer() {
        ChristmasHandler.fmlPreInit();
        if (ChristmasHandler.isEnabled()) {
            ChristmasHandler.replaceLangEntries();
        }
    }

    public static void fmlPreInitClient() {
        ChristmasHandler.fmlPreInit();
        if (ChristmasHandler.isEnabled()) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(m -> ChristmasHandler.replaceLangEntries());
        }
    }

    private static void setColours(int lightColour, int darkColour, BCFluid fluid) {
        if (fluid != null) {
            fluid.setColour(lightColour, darkColour);
            if (fluid.isGaseous()) {
                fluid.setGaseous(false);
            }
            if (fluid.getDensity() < 0) {
                fluid.setDensity(-fluid.getDensity());
            }
        }
    }

    private static void replaceLangEntries() {
        try {
            ChristmasHandler.replaceLangEntries0();
        }
        catch (ReflectiveOperationException e) {
            BCLog.logger.warn("[energy.christmas] Unable to replace language entries! Did something change?", (Throwable)e);
        }
    }

    private static void replaceLangEntries0() throws ReflectiveOperationException {
        Class<LanguageMap> cls = LanguageMap.class;
        Field fldInstance = null;
        Field fldLangMap = null;
        for (Field fld : cls.getDeclaredFields()) {
            if (fld.getType() == cls) {
                if (fldInstance == null) {
                    fldInstance = fld;
                    continue;
                }
                throw new ReflectiveOperationException("Found duplicate fields for instance! (" + fldInstance + " and " + fld + ")");
            }
            if (fld.getType() != Map.class) continue;
            if (fldLangMap == null) {
                fldLangMap = fld;
                continue;
            }
            throw new ReflectiveOperationException("Found duplicate fields for langMap! (" + fldLangMap + " and " + fld + ")");
        }
        if (fldInstance == null) {
            throw new ReflectiveOperationException("Couln't find the instance field!");
        }
        if (fldLangMap == null) {
            throw new ReflectiveOperationException("Couln't find the map field!");
        }
        fldInstance.setAccessible(true);
        fldLangMap.setAccessible(true);
        LanguageMap instance = (LanguageMap)fldInstance.get(null);
        ChristmasHandler.checkAndReplaceEntries((Map)fldLangMap.get(instance));
        fldInstance.setAccessible(false);
        fldLangMap.setAccessible(false);
    }

    private static <K, V> void checkAndReplaceEntries(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V altValue = map.get("buildcraft.christmas." + key);
            if (altValue == null) continue;
            entry.setValue(altValue);
        }
    }
}

