/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.tile.ITileOilSpring;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileMiner;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.ProfilerUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.mj.MjRedstoneBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TilePump
extends TileMiner {
    public static final boolean DEBUG_PUMP = BCDebugging.shouldDebugComplex("factory.pump");
    private static final EnumFacing[] SEARCH_NORMAL = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] SEARCH_GASEOUS = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final ResourceLocation ADVANCEMENT_DRAIN_ANY = new ResourceLocation("buildcraftfactory:draining_the_world");
    private static final ResourceLocation ADVANCEMENT_DRAIN_OIL = new ResourceLocation("buildcraftfactory:oil_platform");
    private final Tank tank = new Tank("tank", 16000, this);
    private boolean queueBuilt = false;
    private final Map<BlockPos, FluidPath> paths = new HashMap<BlockPos, FluidPath>();
    private BlockPos fluidConnection;
    private final Deque<BlockPos> queue = new ArrayDeque<BlockPos>();
    private boolean isInfiniteWaterSource;
    private final SafeTimeTracker rebuildDelay = new SafeTimeTracker(30L);
    private BlockPos targetPos;
    @Nullable
    private BlockPos oilSpringPos;

    public TilePump() {
        this.tank.setCanFill(false);
        this.tankManager.add(this.tank);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tank, EnumPipePart.VALUES);
    }

    @Override
    protected IMjReceiver createMjReceiver() {
        return new MjRedstoneBatteryReceiver(this.battery);
    }

    private void buildQueue() {
        this.queue.clear();
        this.paths.clear();
        Fluid queueFluid = null;
        this.isInfiniteWaterSource = false;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> nextPosesToCheck = new ArrayList<BlockPos>();
        this.targetPos = this.field_174879_c.func_177977_b();
        while (!this.field_145850_b.func_189509_E(this.targetPos) && this.field_174879_c.func_177956_o() - this.targetPos.func_177956_o() <= BCCoreConfig.miningMaxDepth) {
            if (BlockUtil.getFluidWithFlowing(this.field_145850_b, this.targetPos) != null) {
                queueFluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, this.targetPos);
                nextPosesToCheck.add(this.targetPos);
                this.paths.put(this.targetPos, new FluidPath(this.targetPos, null));
                checked.add(this.targetPos);
                if (BlockUtil.getFluid(this.field_145850_b, this.targetPos) != null) {
                    this.queue.add(this.targetPos);
                }
                this.fluidConnection = this.targetPos;
                break;
            }
            if (!this.field_145850_b.func_175623_d(this.targetPos) && this.field_145850_b.func_180495_p(this.targetPos).func_177230_c() != BCFactoryBlocks.tube) break;
            this.targetPos = this.targetPos.func_177977_b();
        }
        if (nextPosesToCheck.isEmpty() || queueFluid == null) {
            return;
        }
        Profiler debugProf = new Profiler();
        debugProf.field_76327_a = DEBUG_PUMP;
        ProfilerUtil.ProfilerEntry prof = ProfilerUtil.createEntry(debugProf, this.field_145850_b.field_72984_F);
        Stopwatch watch = Stopwatch.createStarted();
        debugProf.func_76320_a("root");
        this.buildQueue0(prof, queueFluid, nextPosesToCheck, checked);
        debugProf.func_76319_b();
        watch.stop();
        if (DEBUG_PUMP) {
            ProfilerUtil.logProfilerResults(debugProf, "root", watch.elapsed(TimeUnit.NANOSECONDS));
        }
    }

    private void buildQueue0(ProfilerUtil.ProfilerEntry prof, Fluid queueFluid, List<BlockPos> nextPosesToCheck, Set<BlockPos> checked) {
        prof.startSection("build");
        EnumFacing[] directions = queueFluid.isGaseous() ? SEARCH_GASEOUS : SEARCH_NORMAL;
        boolean isWater = !BCCoreConfig.pumpsConsumeWater && FluidUtilBC.areFluidsEqual(queueFluid, FluidRegistry.WATER);
        int maxLengthSquared = BCCoreConfig.pumpMaxDistance * BCCoreConfig.pumpMaxDistance;
        block4: while (!nextPosesToCheck.isEmpty()) {
            ArrayList<BlockPos> nextPosesToCheckCopy = new ArrayList<BlockPos>(nextPosesToCheck);
            nextPosesToCheck.clear();
            for (BlockPos posToCheck : nextPosesToCheckCopy) {
                IBlockState below;
                Fluid fluidBelow;
                int count = 0;
                for (EnumFacing side : directions) {
                    prof.startSection("check");
                    BlockPos offsetPos = posToCheck.func_177972_a(side);
                    if (offsetPos.func_177951_i((Vec3i)this.targetPos) > (double)maxLengthSquared) {
                        prof.endSection();
                        continue;
                    }
                    boolean isNew = checked.add(offsetPos);
                    prof.endSection();
                    if (isNew) {
                        prof.startSection("push");
                        prof.startSection("eq_get");
                        Fluid fluidAt = BlockUtil.getFluidWithFlowing(this.field_145850_b, offsetPos);
                        prof.endStartSection("eq_cmp");
                        boolean eq = FluidUtilBC.areFluidsEqual(fluidAt, queueFluid);
                        prof.endSection();
                        if (eq) {
                            prof.startSection("prevPath");
                            FluidPath oldPath = this.paths.get(posToCheck);
                            prof.endStartSection("new");
                            FluidPath path = new FluidPath(offsetPos, oldPath);
                            prof.endStartSection("putNew");
                            this.paths.put(offsetPos, path);
                            prof.endStartSection("getFluid");
                            if (BlockUtil.getFluid(this.field_145850_b, offsetPos) != null) {
                                prof.endStartSection("addToQueue");
                                this.queue.add(offsetPos);
                            }
                            prof.endStartSection("next");
                            nextPosesToCheck.add(offsetPos);
                            ++count;
                            prof.endSection();
                        }
                        prof.endSection();
                        continue;
                    }
                    ++count;
                }
                if (!isWater) continue;
                prof.startSection("water_check");
                if (count >= 2 && (FluidUtilBC.areFluidsEqual(fluidBelow = BlockUtil.getFluidWithoutFlowing(below = this.field_145850_b.func_180495_p(posToCheck.func_177977_b())), FluidRegistry.WATER) || below.func_185904_a().func_76220_a())) {
                    this.isInfiniteWaterSource = true;
                    prof.endSection();
                    break block4;
                }
                prof.endSection();
            }
        }
        prof.endStartSection("oil_spring_search");
        if (TilePump.isOil(queueFluid)) {
            ArrayList<BlockPos> springPositions = new ArrayList<BlockPos>();
            BlockPos center = VecUtil.replaceValue((Vec3i)this.func_174877_v(), EnumFacing.Axis.Y, 0);
            for (BlockPos spring : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-10, 0, -10), (BlockPos)center.func_177982_a(10, 0, 10))) {
                TileEntity tile;
                if (this.field_145850_b.func_180495_p(spring).func_177230_c() != BCCoreBlocks.spring || !((tile = this.field_145850_b.func_175625_s(spring)) instanceof ITileOilSpring)) continue;
                springPositions.add(spring);
            }
            switch (springPositions.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.oilSpringPos = (BlockPos)springPositions.get(0);
                    break;
                }
                default: {
                    springPositions.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.field_174879_c).func_177951_i(arg_0)));
                    this.oilSpringPos = (BlockPos)springPositions.get(0);
                }
            }
        }
        prof.endSection();
    }

    private static boolean isOil(Fluid queueFluid) {
        if (BCModules.ENERGY.isLoaded()) {
            return FluidUtilBC.areFluidsEqual(queueFluid, BCEnergyFluids.oil);
        }
        return false;
    }

    private boolean canDrain(BlockPos blockPos) {
        Fluid fluid = BlockUtil.getFluid(this.field_145850_b, blockPos);
        return this.tank.isEmpty() ? fluid != null : FluidUtilBC.areFluidsEqual(fluid, this.tank.getFluidType());
    }

    private void nextPos() {
        while (!this.queue.isEmpty()) {
            this.currentPos = this.queue.removeLast();
            if (!this.canDrain(this.currentPos)) continue;
            this.updateLength();
            return;
        }
        this.currentPos = null;
        this.updateLength();
    }

    @Override
    protected BlockPos getTargetPos() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.targetPos;
    }

    @Override
    public void func_73660_a() {
        if (!this.queueBuilt && !this.field_145850_b.field_72995_K) {
            this.buildQueue();
            this.queueBuilt = true;
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidUtilBC.pushFluidAround((IBlockAccess)this.field_145850_b, this.field_174879_c, this.tank);
        }
    }

    @Override
    public void mine() {
        if (this.tank.getFluidAmount() > this.tank.getCapacity() / 2) {
            return;
        }
        long target = (long)BCCoreConfig.pumpRFPerBlock * MjAPI.MJ / (long)MjAPI.rfPerMj;
        if (this.currentPos != null && this.paths.containsKey(this.currentPos)) {
            this.progress = (int)((long)this.progress + this.battery.extractPower(0L, target - (long)this.progress));
            if ((long)this.progress < target) {
                return;
            }
            FluidStack drain = BlockUtil.drainBlock(this.field_145850_b, this.currentPos, false);
            if (drain == null) {
                if (DEBUG_PUMP) {
                    BCLog.logger.info("Pump @ " + this.func_174877_v() + " tried to drain " + this.currentPos + " but couldn't because no fluid was drained!");
                }
            } else {
                BlockPos invalid = this.getFirstInvalidPointOnPath(this.currentPos);
                if (invalid != null) {
                    if (DEBUG_PUMP) {
                        BCLog.logger.info("Pump @ " + this.func_174877_v() + " tried to drain " + this.currentPos + " but couldn't because the path stopped at " + invalid + "!");
                    }
                } else if (!this.canDrain(this.currentPos)) {
                    if (DEBUG_PUMP) {
                        BCLog.logger.info("Pump @ " + this.func_174877_v() + " tried to drain " + this.currentPos + " but couldn't because it couldn't be drained!");
                    }
                } else {
                    this.tank.fillInternal(drain, true);
                    this.progress = 0;
                    this.isInfiniteWaterSource &= !BCCoreConfig.pumpsConsumeWater;
                    if (this.isInfiniteWaterSource) {
                        this.isInfiniteWaterSource = FluidUtilBC.areFluidsEqual(drain.getFluid(), FluidRegistry.WATER);
                    }
                    AdvancementUtil.unlockAdvancement(this.getOwner().getId(), ADVANCEMENT_DRAIN_ANY);
                    if (!this.isInfiniteWaterSource) {
                        BlockUtil.drainBlock(this.field_145850_b, this.currentPos, true);
                        if (TilePump.isOil(drain.getFluid())) {
                            TileEntity tile;
                            AdvancementUtil.unlockAdvancement(this.getOwner().getId(), ADVANCEMENT_DRAIN_OIL);
                            if (this.oilSpringPos != null && (tile = this.field_145850_b.func_175625_s(this.oilSpringPos)) instanceof ITileOilSpring) {
                                ((ITileOilSpring)tile).onPumpOil(this.getOwner(), this.currentPos);
                            }
                        }
                        this.paths.remove(this.currentPos);
                        this.nextPos();
                    }
                    return;
                }
            }
            if (!this.rebuildDelay.markTimeIfDelay(this.field_145850_b)) {
                return;
            }
        } else {
            if (this.currentPos == null && !this.rebuildDelay.markTimeIfDelay(this.field_145850_b)) {
                return;
            }
            if (DEBUG_PUMP) {
                if (this.currentPos == null) {
                    BCLog.logger.info("Pump @ " + this.func_174877_v() + " is rebuilding it's queue...");
                } else {
                    BCLog.logger.info("Pump @ " + this.func_174877_v() + " is rebuilding it's queue because we don't have a path for " + this.currentPos);
                }
            }
        }
        this.buildQueue();
        this.nextPos();
    }

    @Nullable
    private BlockPos getFirstInvalidPointOnPath(BlockPos from) {
        FluidPath path = this.paths.get(from);
        if (path == null) {
            return from;
        }
        do {
            if (BlockUtil.getFluidWithFlowing(this.field_145850_b, path.thisPos) != null) continue;
            return path.thisPos;
        } while ((path = path.parent) != null);
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.oilSpringPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("oilSpringPos"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.oilSpringPos != null) {
            nbt.func_74782_a("oilSpringPos", (NBTBase)NBTUtilBC.writeBlockPos(this.oilSpringPos));
        }
        return nbt;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_LED_STATUS, buffer, side);
            } else if (id == NET_LED_STATUS) {
                this.tank.writeToBuffer(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_LED_STATUS, buffer, side, ctx);
            } else if (id == NET_LED_STATUS) {
                this.tank.readFromBuffer(buffer);
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("fluid = " + this.tank.getDebugString());
        left.add("queue size = " + this.queue.size());
        left.add("infinite = " + this.isInfiniteWaterSource);
    }

    @Override
    protected long getBatteryCapacity() {
        return 50L * MjAPI.MJ;
    }

    static final class FluidPath {
        public final BlockPos thisPos;
        @Nullable
        public final FluidPath parent;

        public FluidPath(BlockPos thisPos, FluidPath parent) {
            this.thisPos = thisPos;
            this.parent = parent;
        }

        public FluidPath and(BlockPos pos) {
            return new FluidPath(pos, this);
        }
    }
}

