/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.plug;

import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.client.model.MutableQuad;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;

public class PlugBakerSimple<K extends PluggableModelKey>
implements IPluggableStaticBaker<K> {
    private final IQuadProvider provider;
    private final Map<EnumFacing, List<BakedQuad>> cached = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
    private MutableQuad[] lastSeen;

    public PlugBakerSimple(IQuadProvider provider) {
        this.provider = provider;
    }

    @Override
    public List<BakedQuad> bake(K key) {
        MutableQuad[] quads = this.provider.getCutoutQuads();
        if (quads != this.lastSeen) {
            this.cached.clear();
            MutableQuad copy = new MutableQuad();
            for (EnumFacing to : EnumFacing.field_82609_l) {
                ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
                for (MutableQuad q : quads) {
                    copy.copyFrom(q);
                    copy.rotate(EnumFacing.WEST, to, 0.5f, 0.5f, 0.5f);
                    copy.multShade();
                    list.add(copy.toBakedBlock());
                }
                this.cached.put(to, list);
            }
            this.lastSeen = quads;
        }
        return this.cached.get(((PluggableModelKey)key).side);
    }

    public static interface IQuadProvider {
        public MutableQuad[] getCutoutQuads();
    }
}

