/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncBooleanBooleanToDouble
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncBooleanBooleanToDouble function;
    private final StringFunctionTri stringFunction;

    public NodeFuncBooleanBooleanToDouble(String name, IFuncBooleanBooleanToDouble function) {
        this(function, (String a, String b) -> "[ boolean, boolean -> double ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncBooleanBooleanToDouble(IFuncBooleanBooleanToDouble function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncBooleanBooleanToDouble setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeBoolean b = stack.popBoolean();
        IExpressionNode.INodeBoolean a = stack.popBoolean();
        return this.create(a, b);
    }

    public FuncBooleanBooleanToDouble create(IExpressionNode.INodeBoolean argA, IExpressionNode.INodeBoolean argB) {
        return new FuncBooleanBooleanToDouble(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncBooleanBooleanToDouble {
        public double apply(boolean var1, boolean var2);
    }

    public class FuncBooleanBooleanToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeBoolean argA;
        public final IExpressionNode.INodeBoolean argB;

        public FuncBooleanBooleanToDouble(IExpressionNode.INodeBoolean argA, IExpressionNode.INodeBoolean argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public double evaluate() {
            return NodeFuncBooleanBooleanToDouble.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncBooleanBooleanToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncBooleanBooleanToDouble((IExpressionNode.INodeBoolean)a, (IExpressionNode.INodeBoolean)b), (a, b) -> new FuncBooleanBooleanToDouble((IExpressionNode.INodeBoolean)a, (IExpressionNode.INodeBoolean)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncBooleanBooleanToDouble((IExpressionNode.INodeBoolean)a, (IExpressionNode.INodeBoolean)b), (a, b) -> NodeConstantDouble.of(NodeFuncBooleanBooleanToDouble.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncBooleanBooleanToDouble.this.canInline) {
                if (NodeFuncBooleanBooleanToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncBooleanBooleanToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncBooleanBooleanToDouble.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncBooleanBooleanToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncBooleanBooleanToDouble other = (FuncBooleanBooleanToDouble)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

