/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import java.util.Objects;

public class NodeFuncDoubleDoubleToLong
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncDoubleDoubleToLong function;
    private final StringFunctionTri stringFunction;

    public NodeFuncDoubleDoubleToLong(String name, IFuncDoubleDoubleToLong function) {
        this(function, (String a, String b) -> "[ double, double -> long ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncDoubleDoubleToLong(IFuncDoubleDoubleToLong function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncDoubleDoubleToLong setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeDouble a = stack.popDouble();
        return this.create(a, b);
    }

    public FuncDoubleDoubleToLong create(IExpressionNode.INodeDouble argA, IExpressionNode.INodeDouble argB) {
        return new FuncDoubleDoubleToLong(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncDoubleDoubleToLong {
        public long apply(double var1, double var3);
    }

    public class FuncDoubleDoubleToLong
    implements IExpressionNode.INodeLong,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeDouble argA;
        public final IExpressionNode.INodeDouble argB;

        public FuncDoubleDoubleToLong(IExpressionNode.INodeDouble argA, IExpressionNode.INodeDouble argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public long evaluate() {
            return NodeFuncDoubleDoubleToLong.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncDoubleDoubleToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncDoubleDoubleToLong((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> new FuncDoubleDoubleToLong((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncDoubleDoubleToLong((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> NodeConstantLong.of(NodeFuncDoubleDoubleToLong.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncDoubleDoubleToLong.this.canInline) {
                if (NodeFuncDoubleDoubleToLong.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncDoubleDoubleToLong.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncDoubleDoubleToLong.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncDoubleDoubleToLong.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncDoubleDoubleToLong other = (FuncDoubleDoubleToLong)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

