/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncObjectLongToDouble<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncObjectLongToDouble<A> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectLongToDouble(String name, Class<A> argTypeA, IFuncObjectLongToDouble<A> function) {
        this(argTypeA, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", long -> double ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectLongToDouble(Class<A> argTypeA, IFuncObjectLongToDouble<A> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncObjectLongToDouble<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b);
    }

    public FuncObjectLongToDouble create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeLong argB) {
        return new FuncObjectLongToDouble(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncObjectLongToDouble<A> {
        public double apply(A var1, long var2);
    }

    public class FuncObjectLongToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeLong argB;

        public FuncObjectLongToDouble(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeLong argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public double evaluate() {
            return NodeFuncObjectLongToDouble.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncObjectLongToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectLongToDouble(a, (IExpressionNode.INodeLong)b), (a, b) -> new FuncObjectLongToDouble(a, (IExpressionNode.INodeLong)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectLongToDouble(a, (IExpressionNode.INodeLong)b), (a, b) -> NodeConstantDouble.of(NodeFuncObjectLongToDouble.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectLongToDouble.this.canInline) {
                if (NodeFuncObjectLongToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectLongToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncObjectLongToDouble.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectLongToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectLongToDouble other = (FuncObjectLongToDouble)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

