/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public enum FuelRegistry implements IFuelManager
{
    INSTANCE;

    private final List<IFuel> fuels = new LinkedList<IFuel>();

    @Override
    public <F extends IFuel> F addFuel(F fuel) {
        this.fuels.add(fuel);
        return fuel;
    }

    @Override
    public IFuel addFuel(FluidStack fluid, long powerPerCycle, int totalBurningTime) {
        IFuel f = null;
        for (IFuel fuel : this.fuels) {
            if (!fuel.getFluid().isFluidEqual(fluid)) continue;
            f = fuel;
        }
        if (f == null) {
            return this.addFuel(new Fuel(fluid, powerPerCycle, totalBurningTime));
        }
        if (f.getPowerPerCycle() > powerPerCycle) {
            return f;
        }
        this.fuels.remove(f);
        return this.addFuel(new Fuel(fluid, powerPerCycle, totalBurningTime));
    }

    @Override
    public IFuelManager.IDirtyFuel addDirtyFuel(FluidStack fuel, long powerPerCycle, int totalBurningTime, FluidStack residue) {
        return new DirtyFuel(this.addFuel(fuel, powerPerCycle, totalBurningTime));
    }

    @Override
    public Collection<IFuel> getFuels() {
        return this.fuels;
    }

    @Override
    public IFuel getFuel(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        for (IFuel fuel : this.fuels) {
            if (!fuel.getFluid().isFluidEqual(fluid)) continue;
            return fuel;
        }
        return null;
    }

    public static class DirtyFuel
    extends Fuel
    implements IFuelManager.IDirtyFuel {
        private final FluidStack residue;

        public DirtyFuel(FluidStack fluid, long powerPerCycle, int totalBurningTime, FluidStack residue) {
            super(fluid, powerPerCycle, totalBurningTime);
            this.residue = residue;
        }

        public DirtyFuel(IFuel f) {
            this(f.getFluid(), f.getPowerPerCycle(), f.getTotalBurningTime(), new FluidStack(f.getFluid(), 0));
        }

        @Override
        public FluidStack getResidue() {
            return this.residue;
        }
    }

    public static class Fuel
    implements IFuel {
        private final FluidStack fluid;
        private final long powerPerCycle;
        private final int totalBurningTime;

        public Fuel(FluidStack fluid, long powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        @Override
        public FluidStack getFluid() {
            return this.fluid;
        }

        @Override
        public long getPowerPerCycle() {
            return this.powerPerCycle;
        }

        @Override
        public int getTotalBurningTime() {
            return this.totalBurningTime;
        }
    }
}

